/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <QPixmap>
#include <QVariant>


class QSettings;


class Resource
{
public:
    static void setIniFile(const QString &fileName);

    static QPixmap pixmap(const QString &path);
    static void setPixmapPrefix(const QString &prefix);

    static bool containsValue(const QString &key);

    static QVariant value(const QString &key, const QVariant &value = QVariant());

    static int intValue(const QString &key, int value = 0);
    static double doubleValue(const QString &key, double value = 0);
    static QString stringValue(const QString &key, const QString &value = QString());

private:
    Resource();
    ~Resource();
    static Resource *instance();

    QSettings *settings;
    QString pixmapPrefix;
};

#endif
