/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PAGEVIEW_H
#define PAGEVIEW_H

#include <QStack>
#include <QPixmap>
#include <QGraphicsWidget>

class View;
class Button;
class PageMenu;
class PageSlot;


class PageView : public QGraphicsWidget
{
    Q_OBJECT

public:
    PageView(QGraphicsItem *parent = 0);

    bool add(View *view, bool keepAlive = false);
    bool back();

    bool isAnimating() const;

protected:
    void animateTransition(View *oldView, View *newView, bool isBack);

    void resizeEvent(QGraphicsSceneResizeEvent *event);
    void mousePressEvent(QGraphicsSceneMouseEvent *) { }

private slots:
    void backClicked();
    void optionsClicked();
    void transitionFinished();

private:
    bool m_isBack;
    int m_topOffset;
    bool m_isAnimating;

    QStack<View *> m_views;
    QHash<View *, bool> m_keepAlive;

    PageMenu *m_menu;
    Button *m_backButton;
    Button *m_optionsButton;

    PageSlot *m_oldSlot;
    PageSlot *m_newSlot;
};

#endif
