/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "utils.h"
#include <math.h>
#include <QRegExp>


int generateSequentialId()
{
    static int result = 0;
    result++;
    return result;
}

int strToInt(const QString &str, int defaultValue)
{
    bool ok;
    int result = str.toInt(&ok);
    return ok ? result : defaultValue;
}

float strToFloat(const QString &str, qreal defaultValue)
{
    bool ok;
    float result = str.toFloat(&ok);
    return ok ? result : defaultValue;
}

QString getNodeContentText(QDomNode node)
{
    if (node.childNodes().count() == 0 || !node.childNodes().at(0).isText())
        return QString();
    return node.childNodes().at(0).nodeValue();
}

QDateTime readDateTime(const QString &str, bool common)
{
    if (common) {
        QString text = str.right(str.length() - str.indexOf(',') - 1);
        int len = text.indexOf("am", 15);
        len = len < 0 ? text.indexOf("pm", 15) : len;
        text = text.left(len + 2).trimmed();
        return QDateTime::fromString(text, "dd MMM yyyy h:mm ap");
    } else {
        QString text = str;
        if (text.indexOf("+") > 0)
            text = text.left(text.indexOf("+") - 1).trimmed();
        else if (text.indexOf("-") > 0)
            text = text.left(text.indexOf("-") - 1).trimmed();

        return QDateTime::fromString(text, "ddd, dd MMM yyyy hh:mm:ss");
    }
}

double parseTimeZone(const QString &value)
{
    QRegExp rxlen("([\\+|\\-])(\\d\\d)(\\d\\d)");

    if (rxlen.indexIn(value) < 0)
        return 0;
    else {
        double result = rxlen.cap(2).toDouble() + rxlen.cap(3).toDouble() / 60.0;
        return (rxlen.cap(1) == "-") ? -result : result;
    }
}

static double convertToRange(double value)
{
    double k = 2 * M_PI;
    double b = value / k;
    double a = k * (b - (long)(b));
    return (a < 0) ? k + a : a;
}

/*!
  The algorithm in the method below is from a demo implemented
  by Jarmo Lammi.

  The code can be downloaded in the following url:

  http://personal.inet.fi/cool/jjlammi/rscalc.cc
*/
QTime calculateSunriseSunset(const QDate &date, double latit, double longit,
                             double timeZone, bool isSunset)
{
    static double h = 12;
    static double pi = M_PI;
    static double tpi = 2 * M_PI;
    static double rads = (pi / 180.0);

    double d = -7 * (date.year() + (date.month() + 9) / 12) / 4
        + 275 * date.month() / 9 + date.day() + (date.year() * 367) - 730531.5 + h / 24.0;

    double f1 = convertToRange(280.461 * rads + 0.9856474 * rads * d);
    double f2 = convertToRange(357.528 * rads + 0.9856003 * rads * d);
    double lambda = convertToRange(f1 + 1.915 * rads * sin(f2) + .02 * rads * sin(2 * f2));

    double obliq = 23.439 * rads - 0.0000004 * rads * d;

    double alpha = atan2(cos(obliq) * sin(lambda), cos(lambda));
    double delta = asin(sin(obliq) * sin(lambda));

    double LL = f1 - alpha;
    if (f1 < pi) LL += tpi;

    double equation = 1440.0 * (1.0 - LL / tpi);

    double dfo = rads * (0.50 * 0.53 + 34.0 / 60.0);
    if (latit < 0.0) dfo = -dfo;

    double ha = tan(delta + dfo) * tan(latit * rads);
    if (ha > 0.99999) ha = 1.0; // to avoid overflow
    ha = asin(ha) + pi / 2.0;

    double a = 12.0 * ha / pi;
    double b = 12.0 + timeZone - longit / 15.0 + equation / 60.0;
    double r = (!isSunset) ? (b - a) : (b + a);

    if (r > 24.0) r -= 24.0;

    int hour = (int)r;

    return QTime(hour, (int)((r - (double)hour) * 60));
}
