/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QRegExp>
#include <QDomDocument>
#include "bbclocationresolver.h"


#define LOCID_URL "http://news.bbc.co.uk/weather/util/search/SearchResultsNode.xhtml"


BbcLocationResolver::BbcLocationResolver(QObject *parent)
    : LocationResolver(parent)
{

}

QUrl BbcLocationResolver::formatQuery(const QString &query) const
{
    QUrl url(LOCID_URL);
    url.addQueryItem("search", query);
    url.addQueryItem("region", "world");
    url.addQueryItem("startIndex", "1");
    url.addQueryItem("count", "1");

    return url;
}

QString BbcLocationResolver::parseResponse(QIODevice *reply) const
{
    const QString &body = reply->readAll();
    QRegExp rxlen("/weather/forecast/(\\d+)\\?count=1");
    return (rxlen.indexIn(body) < 0) ? QString() : rxlen.cap(1);
}
