TEMPLATE = lib
TARGET = imtk
CONFIG += qt warn_on build_all
DEPENDPATH += .
INCLUDEPATH += .

!isEmpty(STATIC) {
    CONFIG += static
}

unix {
    CONFIG += create_pc create_prl link_pkgconfig staticlib
}

symbian {
    TARGET.UID3=0xe161B1DE
    TARGET.CAPABILITY = NetworkServices

    LIBS += -lesock -lconnmon -lcone -lavkon

    isEmpty(STATIC) {
        DEFINES += BUILD_DLL

        libfiles.sources = imtk.dll
        libfiles.path = /sys/bin
        DEPLOYMENT += libfiles

        # avoid to call abld freeze but does not
        # maintain binary compatibility
        MMP_RULES += EXPORTUNFROZEN
    }
}

HEADERS += widget.h \
           button.h \
           dataresource.h \
           flickablearea.h \
           kineticscroll.h \
           label.h \
           listview.h \
           model.h \
           pageslider.h \
           pixmapwidget.h \
           scrollarea.h \
           scrollbar.h \
           system.h \
           utils.h \
           throbber.h \
           global.h

HEADERS += widget_p.h \
           pixmapwidget_p.h \
           flickablearea_p.h

SOURCES += widget.cpp \
           button.cpp \
           dataresource.cpp \
           flickablearea.cpp \
           kineticscroll.cpp \
           label.cpp \
           listview.cpp \
           model.cpp \
           pageslider.cpp \
           pixmapwidget.cpp \
           scrollarea.cpp \
           scrollbar.cpp \
           system.cpp \
           throbber.cpp \
           utils.cpp


!include(../install.pri) {
    error("File not found: ../install.pri");
}

!include(../include/include.pri) {
    error("File not found: ../include/include.pri");
}

target.path = $$PREFIX/lib

headers.files = $$HEADERS
headers.path = $$PREFIX/include/$$CODENAME

pubheaders.files = $$PUBLIC_HEADERS
pubheaders.path = $$PREFIX/include

INSTALLS += target headers pubheaders

QMAKE_PKGCONFIG_LIBDIR = $$target.path
QMAKE_PKGCONFIG_INCDIR = $$pubheaders.path
