/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QKeyEvent>
#include <QGraphicsWidget>

#include <ImtkThrobber>
#include <QAction>

#include "citypanel.h"
#include "forecastdata.h"
#include "optionspanel.h"
#include "citycarroussel.h"
#include "loadingscreen.h"


class MainWindow : public QGraphicsWidget
{
    Q_OBJECT

public:
    MainWindow(QGraphicsItem *parent = 0);

    void start(bool connected);

protected:
    void setupUI();
    void setupToolbar();
    bool eventFilter(QObject *obj, QEvent *event);

private slots:
    void load();
    void onDataLoaded();
    void onPixmapLoaded();

    void onCityPanelClicked();
    void onCityPanelClosed();

    void onLeftButtonClicked();
    void onRightButtonClicked();

    void onOptionsClosed();

    void bootEnd();

    void onForecastAdded(const ForecastData &data);

    void updateInternalState();
    void onShowForecast();
    void onOptionExit();
    void doAddCity();
    void doRemoveCity();

    void doChangeResource();
    void onCityItemClicked(int index);

public:
    bool m_modelLoaded;
    bool m_pixmapLoaded;

    ImtkLabel *m_leftLabel;
    ImtkLabel *m_rightLabel;
    QGraphicsPixmapItem *m_bottomBar;
    QList<QAction *> m_optionList;
    QList<QAction *> m_optionCityList;
    CityCarroussel *m_carroussel;
    CityPanel *m_cityPanel;
    OptionsPanel *m_optionsPanel;
    LoadingScreen *m_loadingScreen;
    QGraphicsPixmapItem *m_sourceLogo;
    ImtkButton *m_optionsButton;

    bool m_cityOpened;
    bool m_optionsOpened;
    bool m_isInForecast;
};

#endif
