/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QDebug>
#include <QDomDocument>
#include <QNetworkReply>

#include "utils.h"
#include "locationresolver.h"


LocationResolver::LocationResolver(QObject *parent)
    : QObject(parent)
{
    connect(&m_network, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(receiveResponse(QNetworkReply*)));
}

int LocationResolver::resolve(const QString &query)
{
    const QUrl &url = formatQuery(query);
    QNetworkReply *reply = m_network.get(QNetworkRequest(url));

    int result = generateSequentialId();

    m_requests[reply] = result;
    m_storedQueries[result] = query;

    return result;
}

void LocationResolver::receiveResponse(QNetworkReply *reply)
{
    const QUrl &url = reply->request().url();

    if (!m_requests.contains(reply)) {
        qWarning() << "Unexpected request received: " << url.toString();
        return;
    }

    const int requestId = m_requests.take(reply);
    const QString &query = m_storedQueries.take(requestId);

    if (reply->error() != QNetworkReply::NoError) {
        qWarning() << "Location id query error: " << query;
        emit locationQueryError(requestId, query);
        return;
    }

    const QString &locationId = parseResponse(reply);

    if (locationId.isEmpty()) {
        emit locationQueryError(requestId, query);
    } else
        emit locationResolved(requestId, locationId);
}
