/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "loadingscreen.h"
#include "settings.h"
#include "pixmaploader.h"

#include <QPen>
#include <ImtkLabel>
#include <ImtkButton>
#include <ImtkThrobber>
#include <QApplication>


LoadingScreen::LoadingScreen(bool isConnected, QGraphicsItem *parent)
    : QGraphicsWidget(parent)
{
    int w = Settings::windowSize().width();
    int h = Settings::windowSize().height();

    QFont f("Nokia Sans");
    f.setPixelSize(Settings::intValue("bottom-panel-label-font-size"));

    new QGraphicsPixmapItem(PixmapLoader::pixmap("bg_loading"), this);
    QPixmap bottomPixmap = PixmapLoader::pixmap("bt_options_bg");

    QPixmap basePixmap = PixmapLoader::pixmap("city_name_background_bigger");
    QGraphicsPixmapItem *base = new QGraphicsPixmapItem(basePixmap, this);
    base->setPos(0, h - bottomPixmap.height() - basePixmap.height());

    QPixmap logoPixmap = PixmapLoader::pixmap("umbrella");
    QGraphicsPixmapItem *logo = new QGraphicsPixmapItem(logoPixmap, this);
    logo->setX((Settings::windowSize().width() - logo->boundingRect().width()) / 2);
    logo->setY(Settings::intValue("umbrella-top"));

    if (isConnected) {
        QGraphicsSimpleTextItem *loadingLabel = new QGraphicsSimpleTextItem(this);
        loadingLabel->setFont(f);
        loadingLabel->setPen(Qt::NoPen);
        loadingLabel->setBrush(QColor(255, 255, 255, 178));
        loadingLabel->setText(tr("Loading"));

        loadingLabel->setX((w - loadingLabel->boundingRect().width()) / 2);
        loadingLabel->setY(Settings::scaleHeight(255));

        QList<QPixmap> images;
        for (int i = 1; i < 26; i++)
            images << PixmapLoader::pixmap(QString("loading_%1").arg(i));

        ImtkThrobber *m_loading = new ImtkThrobber(images, this);
        m_loading->setX((w - m_loading->size().width()) / 2);
        m_loading->setY(Settings::scaleHeight(300));
        m_loading->start();
    } else {
        ImtkLabel *label = new ImtkLabel(this);
        f.setPixelSize(Settings::scaleHeight(30.0));
        label->setFont(f);
        label->setText(tr("You have no internet connection."
                          " In order to show weather forecasts you need to be connected."));
        label->setMultiline(true);
        label->setAlignment(Qt::AlignCenter);

        label->setPos(Settings::scaleWidth(50), Settings::scaleHeight(180));
        label->resize(Settings::scaleWidth(380), Settings::scaleHeight(300));
    }
}
