/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTSTARS_H
#define FORECASTSTARS_H

#include <QObject>
#include <QGraphicsItem>
#include <QAbstractAnimation>

class ForecastStars : public QObject, public QGraphicsItem
{
    Q_OBJECT
    Q_INTERFACES(QGraphicsItem)
    Q_PROPERTY(qreal progress READ progress WRITE setProgress)
public:
    ForecastStars(int count, QGraphicsItem *parent = 0);
    QAbstractAnimation *getAnimation();

    static int loadImages();

    QRectF rect() const;
    void setRect(QRectF rect);

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

private:
    class Star : public QGraphicsPixmapItem
    {
    public:
        Star(int type, QGraphicsItem *parent);
        const int starType;
    };

    qreal m_progress;
    QRectF m_boundingRect;
    QList<Star*> m_starts;

    void setProgress(qreal progress);
    qreal progress() const { return m_progress; }

    inline bool checkColision(const QRectF &rect1, qreal radius1,
                              const QRectF &rect2, qreal radius2);
    inline bool checkColision(Star *item1, Star *item2);
    inline bool checkColision(Star *star, const QList<Star*> &items);
    inline QPointF getRandomPos(const QRectF &border);
    void updateStarsPositions();

private slots:
    void animationStateChanged(QAbstractAnimation::State newState,
                               QAbstractAnimation::State oldState);
};

#endif // FORECASTSTARS_H
