/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTDATA_H
#define FORECASTDATA_H

#include <QString>
#include "forecast.h"
#include "weatherresponse.h"

#include <QSharedPointer>

class WeatherResponse;

class ForecastData
{
public:
    ForecastData();
    ForecastData(WeatherResponse *data);

    bool isForecast() const;
    bool isObservation() const;

    Forecast::ForecastType type() const;
    bool night() const;
    bool error() const { return m_error; }
    QString key() const;
    QString cityName() const;
    QString weekday() const;

    int lower() const;
    int upper() const;
    int current() const;

    bool isNull() const { return !m_error && !m_data; }

    bool validUpperLower() const;

    QList<ForecastData> forecasts();

    inline bool operator==(const ForecastData &other);
    bool operator!=(const ForecastData &other) { return !operator==(other); }

protected:
    ForecastData(QSharedPointer<WeatherResponse> data,
                 const WeatherResponse::WeekForecast &fore);

private:
    bool m_error;
    bool m_isForecast;
    WeatherResponse::WeekForecast m_fore;
    QSharedPointer<WeatherResponse> m_data;
};

bool ForecastData::operator==(const ForecastData &other)
{
    return type() == other.type() && night() == other.night() && error() == other.error()
        && key() == other.key() && cityName() == other.cityName() && lower() == other.lower()
        && current() == other.current() && upper() == other.upper();
}

#endif
