/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "forecastdata.h"


ForecastData::ForecastData()
  : m_error(false),
    m_isForecast(false),
    m_data(0)
{

}

ForecastData::ForecastData(WeatherResponse *data)
  : m_error(!data),
    m_isForecast(false),
    m_data(data)
{

}

ForecastData::ForecastData(QSharedPointer<WeatherResponse> data,
                           const WeatherResponse::WeekForecast &fore)
  : m_error(!data),
    m_isForecast(true),
    m_fore(fore),
    m_data(data)
{

}

Forecast::ForecastType ForecastData::type() const
{
    if (m_isForecast)
        return m_fore.code;
    else
        return (!m_data) ? Forecast::UnknownForecast : m_data->condition.code;
}

QString ForecastData::key() const
{
    if (m_isForecast && m_data)
        return m_data->locationCode() + m_fore.date.toString();
    else if (m_data)
        return m_data->locationCode();
    else
        return QString();
}

bool ForecastData::isForecast() const
{
    return m_isForecast;
}

bool ForecastData::isObservation() const
{
    return (m_data != 0 && !m_isForecast);
}

bool ForecastData::night() const
{
    if (m_isForecast)
        return false;
    else
        return (!m_data) ? false : m_data->isNight();
}

QString ForecastData::cityName() const
{
    return m_data ? m_data->location.city : QString();
}

QString ForecastData::weekday() const
{
    if (!m_fore.weekdayName.isEmpty())
        return m_fore.weekdayName;

    static QString days[] = {
        QObject::tr("Monday"), QObject::tr("Tuesday"),
        QObject::tr("Wednesday"), QObject::tr("Thursday"),
        QObject::tr("Friday"), QObject::tr("Saturday"),
        QObject::tr("Sunday") };

    if (m_isForecast)
        return days[qBound(0, m_fore.date.dayOfWeek() - 1, 6)];

    return QString();
}

int ForecastData::current() const
{
    if (m_isForecast)
        return 0;

    return m_data ? m_data->condition.temperature : 0;
}

int ForecastData::lower() const
{
    if (m_isForecast)
        return m_fore.low;

    return m_data ? m_data->forecast1.low : 0;
}

int ForecastData::upper() const
{
    if (m_isForecast)
        return m_fore.high;

    return m_data ? m_data->forecast1.high : 0;
}

bool ForecastData::validUpperLower() const
{
    if (m_isForecast)
        return true;

    return m_data ? m_data->forecast1.valid : false;
}

QList<ForecastData> ForecastData::forecasts()
{
    QList<ForecastData> result;

    if (!m_data)
        return result;

    foreach (WeatherResponse::WeekForecast t, m_data->forecasts)
        result << ForecastData(m_data, t);

    return result;
}
