/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef CONTENTLIST_H
#define CONTENTLIST_H

#include <QList>
#include <QObject>
#include <QKeyEvent>
#include <QGraphicsWidget>
#include <QAbstractAnimation>
#include <QPointer>
#include <QGraphicsSceneResizeEvent>



class ContentListItem : public QGraphicsObject
{
    Q_OBJECT

public:
    enum State {
        NormalState,
        PressedState,
        SelectedState
    };

    ContentListItem(QGraphicsItem *parent = 0);

    QRectF boundingRect() const;

    State state() const;
    virtual qreal contentHeight() const = 0;

    virtual QAbstractAnimation *showAnimation() { return 0; }
    virtual QAbstractAnimation *hideAnimation() { return 0; }

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

protected:
    void setState(State state);
    virtual void stateChanged(State newState) { Q_UNUSED(newState); }

    void updateGeometry();
    QVariant itemChange(GraphicsItemChange change, const QVariant &value);

private:
    friend class ContentList;

    State m_state;
    QRectF m_geometry;
    bool m_geometryReady;
};


class ContentList : public QGraphicsWidget
{
    Q_OBJECT

public:
    ContentList(QGraphicsItem *parent = 0);
    ContentList(QList<ContentListItem*> items, QGraphicsItem *parent = 0);

    bool addItem(ContentListItem *item);
    bool insertItem(int idx, ContentListItem*);

    bool removeItem(int idx);
    bool removeItem(ContentListItem* item);

    void appendItems(QList<ContentListItem *> items);

    int itemCount() const;

    ContentListItem* itemAt(int idx) { return m_items.at(idx); }
    int indexFromItem(ContentListItem *item) { return m_items.indexOf(item); }

    void updateItems();

    int currentItem() const { return m_currentItem; }

    void doActivateItem(ContentListItem *item);

signals:
    void itemActivated(int index);

protected slots:
    virtual void onItemActivated(int) {}
    void doInsertItem(bool reposition = false);
    void doRemoveItem(bool reposition = false);

protected:
    void keyPressEvent(QKeyEvent *event);
    void keyReleaseEvent(QKeyEvent *event);
    void resizeEvent(QGraphicsSceneResizeEvent *e);

    virtual QAbstractAnimation *insertAnimation(int idx, qreal height);
    virtual QAbstractAnimation *removeAnimation(int idx);

    QList<ContentListItem*> getItems() { return m_items; }
    bool setItemState(int index, ContentListItem::State state);

private:
    bool m_frozen;
    int m_lastIndex;
    bool m_itemPressed;
    int m_currentItem;
    QList<ContentListItem*> m_items;
};

#endif
