/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "citypanel.h"
#include "settings.h"
#include "pixmaploader.h"
#include "forecastmodel.h"

#include <QPainter>
#include <QPropertyAnimation>
#include <QGraphicsSceneMouseEvent>
#include <QSequentialAnimationGroup>


CityPanel::CityPanel(Carroussel<ImtkLabel *> *label, QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      m_isExpanded(false),
      m_label(label)
{
    setFlag(QGraphicsItem::ItemHasNoContents, true);

    const QPixmap &barPixmap = PixmapLoader::pixmap("city_name_background_bigger");

    m_cityBoard = new QGraphicsWidget(this);
    m_cityBoard->setFlag(QGraphicsItem::ItemHasNoContents);
    m_cityBoard->resize(Settings::windowSize());

    m_cityBar = new ImtkButton(barPixmap, this);
    m_cityBar->setZValue(2.0);

    m_bottomY = size().height() - m_cityBar->size().height();

    m_list = new CityList(m_cityBoard);
    m_list->setY(m_list->initialTop());
    m_list->setOpacity(0.0);

    m_cityBoard->setY(m_bottomY - m_list->initialTop());

    m_contents = m_list->scroll();
    m_contents->setVisible(false);
    m_contents->setOpacity(0.0);

    m_addTool = new AddCityTool(m_cityBoard);
    m_addTool->setY(m_list->boundingRect().bottom());

    connect(m_cityBar, SIGNAL(clicked()),SIGNAL(cityNameClicked()));
    connect(m_addTool, SIGNAL(newForecast(ForecastData)),
            this, SLOT(onNewForequest(ForecastData)));

    m_cityBar->setY(size().height() - m_cityBar->size().height() - m_list->y());
}

void CityPanel::setInputFocus()
{
    m_addTool->setInputFocus();
}

void CityPanel::onNewForequest(ForecastData data)
{
    ForecastModel *model = ForecastModel::instance();
    model->add(data);
}

void CityPanel::expand()
{
    if (m_isExpanded)
        return;

    int y = Settings::intValue("citylist-top-offset");

    m_contents->setVisible(true);
    m_cityBoard->setVisible(true);

    QPropertyAnimation *animation;
    QSequentialAnimationGroup *result = new QSequentialAnimationGroup();

    animation = new QPropertyAnimation(m_label->at(0), "opacity");
    animation->setEndValue(0.0);
    animation->setDuration(50);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_list, "opacity");
    animation->setEndValue(1.0);
    animation->setDuration(100);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_cityBar, "opacity");
    animation->setEndValue(0.0);
    animation->setDuration(100);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_cityBoard, "y");
    animation->setEndValue(y);
    animation->setEasingCurve(QEasingCurve::OutQuart);
    animation->setDuration(500);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_contents, "opacity");
    animation->setEndValue(1.0);
    animation->setDuration(100);
    result->addAnimation(animation);

    connect(result, SIGNAL(finished()), this, SLOT(onExpanded()));

    result->start(QAbstractAnimation::DeleteWhenStopped);
}

void CityPanel::collapse()
{
    if (!m_isExpanded)
        return;

    m_label->at(0)->setVisible(true);
    m_cityBar->setVisible(true);

    QPropertyAnimation *animation;
    QSequentialAnimationGroup *result = new QSequentialAnimationGroup();

    animation = new QPropertyAnimation(m_contents, "opacity");
    animation->setEndValue(0.0);
    animation->setDuration(300);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_cityBoard, "y");
    animation->setEndValue(m_bottomY - m_list->y());
    animation->setEasingCurve(QEasingCurve::OutQuart);
    animation->setDuration(500);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_cityBar, "opacity");
    animation->setEndValue(1.0);
    animation->setDuration(100);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_list, "opacity");
    animation->setEndValue(0.0);
    animation->setDuration(100);
    result->addAnimation(animation);

    animation = new QPropertyAnimation(m_label->at(0), "opacity");
    animation->setEndValue(1.0);
    animation->setDuration(50);
    result->addAnimation(animation);

    connect(result, SIGNAL(finished()), this, SLOT(onCollapsed()));

    result->start(QAbstractAnimation::DeleteWhenStopped);
}

void CityPanel::onExpanded()
{
    m_label->at(0)->setOpacity(0.0);
    m_label->at(0)->setVisible(false);
    m_cityBar->setOpacity(0.0);
    m_cityBar->setVisible(false);

    m_isExpanded = true;
    emit expanded();
    m_list->contents()->setFocus(Qt::TabFocusReason);
}

void CityPanel::onCollapsed()
{
    m_contents->setOpacity(0.0);
    m_contents->setVisible(false);
    m_list->setOpacity(0.0);
    m_cityBoard->setVisible(false);

    m_isExpanded = false;
    emit collapsed();
}

void CityPanel::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    QGraphicsWidget::resizeEvent(event);

    m_bottomY = size().height() - m_cityBar->boundingRect().height();
    m_cityBar->setY(m_bottomY);
    m_cityBoard->setY(m_bottomY - m_list->y());
}


void CityPanel::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    QGraphicsWidget::mousePressEvent(event);
    collapse();
}

bool CityPanel::isExpanded() const
{
    return m_isExpanded;
}
