/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef IMTKSCROLLBAR_H
#define IMTKSCROLLBAR_H

#include "global.h"
#include "pixmapwidget.h"

class QPixmap;
class QGraphicsItem;
class ImtkScrollBarPrivate;


class IMTK_EXPORT ImtkScrollBar : public ImtkPixmapWidget
{
    Q_OBJECT

public:
    ImtkScrollBar(const QPixmap &background, const QPixmap &foreground,
                  QGraphicsItem *parent = 0);

    int value() const;
    void setValue(int value);

    int maximum() const;
    void setMaximum(int maximum);

    int pageSize() const;
    void setPageSize(int pageSize);

    void setFadeEffect(bool enabled);

    void setKnobBorders(int left, int top, int right, int bottom);

protected:
    void resizeEvent(QGraphicsSceneResizeEvent *event);

private:
    IMTK_DECLARE_PRIVATE(ImtkScrollBar);
    Q_PRIVATE_SLOT(d_func(), void _q_fadeTimeout());
};

#endif
