/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPainter>

#include "utils.h"
#include "label.h"
#include "widget_p.h"


class ImtkLabelPrivate : public ImtkWidgetPrivate
{
public:
    ImtkLabelPrivate(ImtkLabel *qptr);

    int flags;
    QString text;
    QColor fontColor;
    Qt::Alignment alignment;
    Qt::TextElideMode elideMode;

private:
    IMTK_DECLARE_PUBLIC(ImtkLabel);
};


ImtkLabelPrivate::ImtkLabelPrivate(ImtkLabel *qptr)
    : ImtkWidgetPrivate(qptr),
      flags(Qt::TextSingleLine),
      fontColor(Qt::white),
      alignment(Qt::AlignLeft),
      elideMode(Qt::ElideRight)
{

}


ImtkLabel::ImtkLabel(QGraphicsItem *parent)
    : ImtkWidget(*new ImtkLabelPrivate(this), parent)
{
    setFont(QFont("Nokia Sans"));
}

QString ImtkLabel::text() const
{
    Q_D(const ImtkLabel);
    return d->text;
}

void ImtkLabel::setText(const QString &value)
{
    Q_D(ImtkLabel);
    if (d->text != value) {
        d->text = value;
        update();
    }
}

QColor ImtkLabel::fontColor() const
{
    Q_D(const ImtkLabel);
    return d->fontColor;
}

void ImtkLabel::setFontColor(const QColor &color)
{
    Q_D(ImtkLabel);
    if (d->fontColor != color) {
        d->fontColor = color;
        update();
    }
}

bool ImtkLabel::isMultiline() const
{
    Q_D(const ImtkLabel);
    return !(d->flags & Qt::TextSingleLine);
}

void ImtkLabel::setMultiline(bool multiline)
{
    Q_D(ImtkLabel);

    if (isMultiline() == multiline)
        return;

    if (multiline) {
        d->flags &= ~Qt::TextSingleLine;
        d->flags |= Qt::TextWordWrap;
    } else {
        d->flags &= ~Qt::TextWordWrap;
        d->flags |= Qt::TextSingleLine;
    }

    updateGeometry();
    update();
}


Qt::TextElideMode ImtkLabel::elideMode() const
{
    Q_D(const ImtkLabel);
    return d->elideMode;
}

void ImtkLabel::setElideMode(Qt::TextElideMode mode)
{
    Q_D(ImtkLabel);
    if (d->elideMode != mode) {
        d->elideMode = mode;
        update();
    }
}

void ImtkLabel::setAlignment(Qt::Alignment alignment)
{
    Q_D(ImtkLabel);
    if (d->alignment != alignment) {
        d->alignment = alignment;
        update();
    }
}

void ImtkLabel::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                      QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    Q_D(ImtkLabel);

    if (d->text.isEmpty())
        return;

    bDrawText(painter, boundingRect(), d->text, font(), d->fontColor,
              d->flags | d->alignment, d->elideMode);
}
