/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SYMBIAN_NETWORK_H
#define SYMBIAN_NETWORK_H

#include <es_sock.h>
#include <sys/socket.h>
#include <net/if.h>
#include <rconnmon.h>


#include <stdarg.h>
#include <e32std.h>

/*
void writeDebugMsg(const char* msg, ...)
{
	static char buffer[1024];

    va_list args;
    va_start( args, msg);
	vsprintf(buffer, msg, args);
    va_end( args);

	FILE *logfile;
	logfile = fopen("C:\\Data\\weather.log", "a");
	fprintf(logfile, "%s\n", buffer);
	fclose(logfile);
}
*/

QString qt_TDesC2QStringL(const TDesC& aDescriptor) 
{
#ifdef QT_NO_UNICODE
    return QString::fromLocal8Bit(aDescriptor.Ptr(), aDescriptor.Length());
#else
    return QString::fromUtf16(aDescriptor.Ptr(), aDescriptor.Length());
#endif
}

static bool useCurrentConnectionL(RConnectionMonitor &monitor)
{
    TUint count;
    TRequestStatus status;
	monitor.GetConnectionCount(count, status);
	User::WaitForRequest(status);
    User::LeaveIfError(status.Int());
	if (count <= 0)
		return false;
	
    TUint connId;
    TUint subConnCount;
    User::LeaveIfError(monitor.GetConnectionInfo(1, connId, subConnCount));
    TBuf<50> iapName;
    monitor.GetStringAttribute(connId, 0, KIAPName, iapName, status);
    User::WaitForRequest(status);
    User::LeaveIfError(status.Int());

    QString strIapName = qt_TDesC2QStringL(iapName);
    struct ifreq ifReq;
    strcpy(ifReq.ifr_name, strIapName.toLatin1().data());
    User::LeaveIfError(setdefaultif(&ifReq));
    return true;
}

static bool useCurrentConnectionL()
{
    RConnectionMonitor monitor;
    if (monitor.ConnectL() != KErrNone)
    	return false;
	CleanupClosePushL(monitor);
	bool result = useCurrentConnectionL(monitor);
    CleanupStack::PopAndDestroy();
    return result;
}

static bool useCurrentConnection()
{
	bool result = false;
	TRAPD(error, result = useCurrentConnectionL());
	return error == KErrNone && result;
}

static void createNewConnectionL()
{
    RSocketServ server;
    User::LeaveIfError(server.Connect());
    CleanupClosePushL(server);

    RConnection connection;
    User::LeaveIfError(connection.Open(server));
    CleanupClosePushL(connection);
    User::LeaveIfError(connection.Start());

    _LIT(KIapName, "IAP\\Name");
    TBuf8<50> iapName;
    User::LeaveIfError(connection.GetDesSetting(TPtrC(KIapName), iapName));
    connection.Stop();
    CleanupStack::PopAndDestroy(2);

    iapName.ZeroTerminate();
    struct ifreq ifReq;
    strcpy(ifReq.ifr_name, (char*)iapName.Ptr());
    User::LeaveIfError(setdefaultif(&ifReq));
}

static bool createNewConnection()
{
	TRAPD(error, createNewConnectionL());
	return error == KErrNone;
}

static bool connect()
{
	return useCurrentConnection() || createNewConnection();
}

#endif
