#ifndef OPTIONSLIST_H
#define OPTIONSLIST_H

#include "contentlist.h"

#include <ImtkLabel>
#include <ImtkButton>
#include <ImtkScrollBar>
#include <ImtkScrollArea>
#include <QAction>
#include <QGraphicsItem>


class OptionsContentList;


class OptionsListItem : public ContentListItem
{
    Q_OBJECT

public:
    OptionsListItem(QAction *action, OptionsContentList *list);

    void select(bool selected);

    void doActivate();
    QString text() const { return m_text->text(); }

    qreal contentHeight() const;

protected:
    void stateChanged(ContentListItem::State state);
    void mousePressEvent(QGraphicsSceneMouseEvent *event);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);

protected slots:
    void onUpdate();

private:
    const qreal m_height;
    OptionsContentList * const m_list;
    QGraphicsPixmapItem * const m_background;
    ImtkLabel *m_text;
    QAction *m_action;
};


class OptionsContentList : public ContentList
{
    Q_OBJECT

public:
    OptionsContentList();


    void select(const QString &selected);
    void setOptions(const QList<QAction *> &options);

signals:
    void itemClicked(int index);

protected:
    virtual void onItemActivated(int index);

private:
    friend class OptionsListItem;
};


class OptionsList : public QGraphicsWidget
{
    Q_OBJECT

public:
    OptionsList(QGraphicsItem *parent = 0);

    void setOptions(const QList<QAction *> &options);
    void select(const QString &selected) { m_list->select(selected); }

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget = 0);

    OptionsContentList *contents() const;

    static int loadImages();

    qreal desiredHeight() const;

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

private:
    const QPixmap m_topPixmap;
    const qreal m_itemHeight;

    OptionsContentList * const m_list;
    ImtkScrollArea *m_scrollBox;
};

#endif
