/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef FORECASTRESOLVER_H
#define FORECASTRESOLVER_H

#include "forecastdata.h"
#include "locationresolver.h"

#include <QMap>
#include <QNetworkAccessManager>


class ForecastResolver : public QObject
{
    Q_OBJECT

public:
    ForecastResolver(QObject *parent = 0);
    virtual ~ForecastResolver();

    int resolve(const QString &locId);
    int resolveByQuery(const QString &query);

    virtual bool isDual() const { return false; };

public slots:
    void resolve(int reqId, const QString &locId);

signals:
    void forecastResolved(int reqId, WeatherResponse *forecast);
    void forecastResponseError(int reqId);

protected:
    ForecastResolver(LocationResolver *resolver, QObject *parent = 0);

    virtual void resolveForecast(const QString &locId);

    virtual QString locationParam() const = 0;
    virtual QUrl formatQuery(const QString &id, bool isForecast = false) const = 0;
    virtual WeatherResponse *parseResponse(const QString &locationId,
                                           QIODevice *reply) const = 0;

    virtual bool parseForecastResponse(WeatherResponse *, QIODevice *) const { return false; }

private slots:
    void receiveResponse(QNetworkReply *reply);
    void forecastReceiveResponse(QNetworkReply *reply);

private:
    LocationResolver *m_locationResolver;
    QNetworkAccessManager m_network;
    QNetworkAccessManager m_network2;

    QHash<QString, WeatherResponse *> m_responses;
    QMap<QString, QList<int> > m_requests;

    void doAddRequest(int reqId, const QString &locId);
};

#endif
