/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef ADDCITYTOOL_H
#define ADDCITYTOOL_H

#include <QGraphicsItem>
#include <QGraphicsPixmapItem>
#include <QBasicTimer>
#include <QGraphicsSimpleTextItem>
#include <QPen>
#include <QBrush>
#include <QFont>
#include <QGraphicsProxyWidget>
#include <QLineEdit>
#include <QList>
#include <QTimer>

#include <ImtkLabel>
#include <ImtkButton>
#include <ImtkThrobber>
#include "forecastdata.h"

class AddCityScreen : public QGraphicsItem
{
public:
    AddCityScreen(const QRectF &boundingRect, QGraphicsItem *parent = 0);

    QRectF boundingRect () const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

private:
    const QRectF m_boundingRect;
};

class AddCityLineEdit : public QLineEdit
{
    Q_OBJECT

public:
    AddCityLineEdit(QWidget *parent = 0);
    void editReset();
protected:
    void focusInEvent(QFocusEvent *event);
    void focusOutEvent(QFocusEvent *event);

    void keyReleaseEvent(QKeyEvent *event);

private:
    bool m_clean;
private slots:
    void textEditedSlot(const QString & text);
};


class AddCityFirstScreen : public QObject, public AddCityScreen
{
    Q_OBJECT

public:
    AddCityFirstScreen(const QRectF &boundingRect, QGraphicsItem *parent = 0);
    void clean();

    void setInputFocus() { m_lineEdit->setFocus(); };

signals:
    void citySelected(const QString &city);

private:
    QGraphicsPixmapItem * const m_textBackground;
    ImtkButton * const m_button;
    QString m_text;
    QGraphicsProxyWidget *m_proxy;
    AddCityLineEdit *m_lineEdit;

private slots:
    void submit();
};

class AddCitySearchScreen : public QObject , public AddCityScreen
{
    Q_OBJECT

public:
    AddCitySearchScreen(const QRectF &boundingRect, QGraphicsItem *parent = 0);
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);
    void setCityName(const QString &name);
    void cancel() { reset(); }

signals:
    void forecastReceived(const ForecastData &forecast);
    void forecastRequestError(const QString &name);

private:
    QString m_city;
    int m_reqId;
    ImtkThrobber *m_loading;
    ImtkLabel *m_label;

    void reset();

private slots:
    void forecastResponse(int reqId, const ForecastData &forecast);
};

class AddCityErrorScreen : public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT

public:
    enum ErrorType {
        NotFound,
        AlreadyInList
    };

    AddCityErrorScreen(QGraphicsItem *parent = 0);

    void setCityName(const QString &name, ErrorType type);

signals:
    void closed();

private:
    ImtkLabel *m_label;
    ImtkButton *m_button;
};

class AddCityTool : public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT

public:
    AddCityTool(QGraphicsItem *parent = 0);
    ~AddCityTool();
    void cancel();

    void setInputFocus();

    static int loadImages();

private:
    QTimer m_timer;
    AddCityFirstScreen * const m_firstScreen;
    AddCitySearchScreen * const m_SearchScreen;
    AddCityErrorScreen * const m_ErrorScreen;

    AddCityFirstScreen *createFirstScreen();
    AddCitySearchScreen *createSearchScreen();
    AddCityErrorScreen *createErrorScreen();

    void setCurrentScreen(QGraphicsItem *screen);

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *event);

signals:
    void newForecast(const ForecastData &forecast);

private slots:
    void backToSearch();
    void errorScreenClosed();
    void forecastReceived(const ForecastData &forecast);
    void forecastRequestError(const QString &name);
    void citySelected(const QString &city);

};

#endif // ADDCITYTOOL_H
