#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenu>
#include <QMessageBox>
#include "theme.h"
#include "screenshotmaker.h"
#include <QModelIndex>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    static QString ScreenshotPath;

private:
    Ui::MainWindow *ui;

    QMenu* m_ThemeMenu;
    void getThemesList();
    QList<Theme*> m_Themes;
    ScreenshotMaker* m_ScrenshotMaker;

    void createMainMenu();
    void createContextMenu();
    QMessageBox::StandardButton ConfirmMessage(QWidget* parent, QString title, QString message);
    void InfoMessage(QWidget* parent, QString message);

private slots:
    void onListDoubleClicked(QModelIndex);
    void onListRowChanged(int row);
    void onScreenshotMakerFinished();
    void onNewScreenshot(Theme* theme, QString filename);
    void themeMenuSlot(QPoint);

    void previewThemeSlot();
    void setActiveThemeSlot();
    void updateScreenshotThemeSlot();
    void clearCacheSlot();
};

#endif // MAINWINDOW_H
