//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include <QtGui/QApplication>
#include "lockscreen.h"
#include <QFile>
#include <QDir>
#include <QTranslator>
#include <iostream>

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

void SimpleLoggingHandler(QtMsgType type, const char *msg)
{
    if (!LockScreen::Debug)
        return;

    switch (type) {
        case QtDebugMsg:
            std::cout << "Debug: " << msg << std::endl;
            break;
        case QtCriticalMsg:
            std::cout  << "Critical: " << msg << std::endl;
            break;
        case QtWarningMsg:
            std::cout  << "Warning: " << msg << std::endl;
            break;
        case QtFatalMsg:
            std::cout  << "Fatal: " << msg << std::endl;
            abort();
    }
}
int main(int argc, char *argv[])
{
#ifdef Q_WS_MAEMO_5
    LockScreen::Debug = false;
    if (argc > 1 && QString(argv[1]) == "-d")
        LockScreen::Debug = true;
#else
    LockScreen::Debug = true;
#endif
    QApplication a(argc, argv);
    a.setOrganizationName("sakya");
    a.setApplicationName("QtLockscreen");
    a.setApplicationVersion(QUOTE(APP_VERSION));
    qInstallMsgHandler(SimpleLoggingHandler);

    QSettings().setDefaultFormat(QSettings::IniFormat);
    QString name = QSettings().fileName();
    QFileInfo pathInfo(name);
    if (!QDir().exists(pathInfo.path()))
        QDir().mkpath(pathInfo.path());

    //Always copy the default current settings:
    QString def = QString("%1.default").arg(name);
    if (QFile::exists(def))
        QFile::remove(def);
    QFile::copy(":/DefaultSettings.conf", QString("%1.default").arg(name));

    //Copy the default settings if the file does not exists.
    if (!QFile::exists(name))
        QFile::copy(":/DefaultSettings.conf", name);

    //Translation:
    QString locale = QSettings().value("Main/Locale", "").toString();
    if (!locale.isEmpty()){
        qDebug() << "Locale override:" << locale;
        QLocale l(locale);
        QLocale::setDefault(l);
    }else
        locale = QLocale::system().name();
    qDebug() << "Locale:" << locale;
    QTranslator translator;
    if (translator.load(QString("/opt/qtlockscreen/qtlockscreen_%1").arg(locale)))
        a.installTranslator(&translator);

    qDebug() << a.applicationName() << a.applicationVersion();
    qDebug() << "Copyright  2011 Paolo Iommarini";
    qDebug() << "sakya_tg@yahoo.it";
    LockScreen l;

    if (LockScreen::Debug || LockScreen::isLocked())
        l.show();

    int res = a.exec();

    return res;
}
