#include "systemfmtx.h"

SystemFMTX::SystemFMTX(QObject *parent) :
    QObject(parent)
{
#ifdef Q_WS_MAEMO_5
    m_fmtxGConf = new GConfItem("/system/fmtx/enabled", this);
    m_fmtxEnabled = m_fmtxGConf->value().toBool();
    connect(m_fmtxGConf, SIGNAL(valueChanged()), this, SLOT(onMaemoFMTXStateChanged()));
#endif
}


void SystemFMTX::turnOn()
{
#ifdef Q_WS_MAEMO_5
    setValue("state", "enabled");
#endif
}

void SystemFMTX::turnOff()
{
#ifdef Q_WS_MAEMO_5
    setValue("state", "disabled");
#endif
}

void SystemFMTX::setEnabled(bool enabled)
{
    if (enabled)
        turnOn();
    else
        turnOff();
}

bool SystemFMTX::state()
{
    return this->isFmtxEnabled();
}

bool SystemFMTX::isFMTXAvailable()
{
#ifdef Q_WS_MAEMO_5
    return true;
#else
    return false;
#endif
}

bool SystemFMTX::isFmtxEnabled()
{
    return m_fmtxEnabled;
}

#ifdef Q_WS_MAEMO_5
void SystemFMTX::setValue(QString property, QVariant value)
{
    QDBusMessage message = QDBusMessage::createMethodCall (FMTX_SERVICE, FMTX_OBJ_PATH, DBUS_INTERFACE_PROPERTIES, DBUS_PROPERTIES_SET);
    QList<QVariant> list;
    list << DBUS_INTERFACE_PROPERTIES << property << QVariant::fromValue(QDBusVariant(value));
    message.setArguments(list);

    QDBusReply<QDBusVariant> response = QDBusConnection::systemBus().call(message);

    QString error;

    if (property == "rds_text")
        error.append("Unable to set RDS info text: ");
    else if (property == "frequency")
        error.append("Unable to set frequency:");
    else if (property == "rds_ps")
        error.append("Unable to set RDS station name:");
    else if (property == "state")
        error.append("Unable to set FmTx state:");

    if (!response.isValid () && response.error().type() != QDBusError::InvalidSignature)
           qWarning () << error << response.error().message();
}

void SystemFMTX::onMaemoFMTXStateChanged()
{
    bool isEnabled = m_fmtxGConf->value().toBool();
    if (m_fmtxEnabled == isEnabled)
        return;

    m_fmtxEnabled = isEnabled;
    emit stateChanged(m_fmtxEnabled);
}
#endif
