//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSWEATHER_H
#define LSWEATHER_H

#include <QProcess>
#include <QDateTime>
#include "lswidget.h"

class LsWeather : public QObject, public LsWidget
{
    Q_OBJECT
public:
    LsWeather(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void stopUpdate();
    void startUpdate();
    void applySettings();

private:
    QTimer* m_UpdateTimer;

    bool m_ShowImage;
    QString m_ConditionsText;
    QPoint m_ConditionsPos;
    QFont m_ConditionsFont;
    QColor m_ConditionsColor;
    QString m_CurrentText;
    QPoint m_CurrentPos;
    QFont m_CurrentFont;
    QColor m_CurrentColor;
    QString m_HighText;
    QPoint m_HighPos;
    QFont m_HighFont;
    QColor m_HighColor;
    QString m_LowText;
    QPoint m_LowPos;
    QFont m_LowFont;
    QColor m_LowColor;

    int m_MinimumSecs;
    QDateTime m_LastUpdate;
    QPixmap m_Image;
    QProcess* m_Process;
    QString m_Link;
    QString m_Unit;

private slots:
    void updateWeather();
    void netStateChanged(QString, QString type, QString state, QString);
    void onProcessFinished(int exitCode, QProcess::ExitStatus exitStatus);
};

#endif // LSWEATHER_H
