//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsbluetooth.h"
#include "lockscreen.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusArgument>
#include <QtDBus>

//DBus property structure
struct DbusProperty
{
    QString name;
    QDBusVariant value;
};
Q_DECLARE_METATYPE(DbusProperty)

//Marshall
QDBusArgument &operator<<(QDBusArgument &argument, const DbusProperty &mystruct)
{
    argument.beginStructure();
    argument << mystruct.name << mystruct.value;
    argument.endStructure();
    return argument;
}

//Demarshall
const QDBusArgument &operator>>(const QDBusArgument &argument, DbusProperty &mystruct)
{
    argument.beginStructure();
    argument >> mystruct.name >> mystruct.value;
    argument.endStructure();
    return argument;
}
//END DBus property structure
#endif


LsBluetooth::LsBluetooth(QString name) :
        LsImage(name.isEmpty() ? "Bluetooth": name)
{
    applySettings();
#ifdef Q_WS_MAEMO_5
    qDBusRegisterMetaType<DbusProperty>();
#endif
    if (LockScreen::Debug){
        m_IsOn = true;
        setImage();
    }
#ifdef Q_WS_MAEMO_5
    m_IsOn = false;
#else
    m_IsOn = true;
    setImage();
#endif
}


void LsBluetooth::applySettings()
{
    m_Adapter = getAdapter();
    m_On = getSetting("ImageOn", "/opt/qtlockscreen/default/bluetooth.png").toString();
    m_Off = getSetting("ImageOff", "").toString();

    setSizeAndPosition(QSize(18, 11),QPoint(0, 0));
}

void LsBluetooth::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!LockScreen::Debug)
        getStatus();
    if (!m_Adapter.isEmpty())
        QDBusConnection::systemBus().connect("", m_Adapter, "org.bluez.Adapter",
                                             "PropertyChanged", this, SLOT(onPropertyChange(QDBusMessage)));
#endif
}

void LsBluetooth::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!m_Adapter.isEmpty())
        QDBusConnection::systemBus().disconnect("", m_Adapter, "org.bluez.Adapter",
                                                "PropertyChanged", this, SLOT(onPropertyChange(QDBusMessage)));
#endif
}

#ifdef Q_WS_MAEMO_5
void LsBluetooth::onPropertyChange(QDBusMessage msg)
{
    if (msg.arguments().count() > 1){
        QString p = msg.arguments().at(0).toString();
        if (p == "Powered"){
            bool on = msg.arguments().at(1).toBool();
            if (m_IsOn != on){
                m_IsOn = on;
                qDebug() << "Bluetooth state changed:" << m_IsOn;
                setImage();
            }
        }
    }
}
#endif

QString LsBluetooth::getAdapter()
{
    QString res;
#ifdef Q_WS_MAEMO_5
    QDBusInterface device(QLatin1String("org.bluez"),
                          QLatin1String("/"),
                          QLatin1String("org.bluez.Manager"),
                          QDBusConnection::systemBus());
    qDebug() << "org.bluez.Manager::DefaultAdapter";
    QDBusMessage msg = device.call(QLatin1String("DefaultAdapter"));
    if (msg.type() == QDBusMessage::ErrorMessage)
        qWarning() << msg.errorMessage();
    else{
        if (msg.arguments().count() > 0){
            QDBusObjectPath p = qvariant_cast<QDBusObjectPath>(msg.arguments().at(0));
            res = p.path();
            qDebug() << "Bluetooth default adapter:" << res;
        }
    }
#endif
    return res;
}

void LsBluetooth::getStatus()
{
#ifdef Q_WS_MAEMO_5
    if (!m_Adapter.isEmpty()){
        QDBusInterface device(QLatin1String("org.bluez"),
                              m_Adapter,
                              QLatin1String("org.bluez.Adapter"),
                              QDBusConnection::systemBus());
        qDebug() << "org.bluez.Adapter::GetProperties";
        QDBusMessage msg = device.call(QLatin1String("GetProperties"));
        if (msg.type() == QDBusMessage::ErrorMessage)
            qWarning() << msg.errorMessage();
        else{
            QDBusArgument arg = qvariant_cast<QDBusArgument>(msg.arguments().at(0));

            arg.beginArray();
            while (!arg.atEnd()) {
                DbusProperty prop;
                arg >> prop;
                //qDebug() << prop.name << prop.value.variant();
                if (prop.name == "Powered"){
                    m_IsOn = prop.value.variant().toBool();
                    qDebug() << "Bluetooth state:" << m_IsOn;
                    setImage();
                    break;
                }
            }
            arg.endArray();
        }
    }
#endif
}

void LsBluetooth::setImage()
{
    if (m_IsOn)
        m_Image = QPixmap(m_On);
    else
        m_Image = QPixmap(m_Off);
}
