//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lstextcommand.h"
#include "lockscreen.h"

LsTextCommand::LsTextCommand(QString name) :
        LsText(name.isEmpty() ? "TextCommand": name)
{
    m_Process = NULL;
    m_Timer = NULL;
    m_UpdateInterval = 0;
    applySettings();
}


void LsTextCommand::applySettings()
{
    m_Command = getSetting("Command", "").toString();
    m_UpdateInterval = getSetting("UpdateIntervalSeconds", 0).toInt();
    if (m_UpdateInterval > 0){
        m_Timer = new QTimer(this);
        m_Timer->setSingleShot(false);
        m_Timer->setInterval(m_UpdateInterval * 1000);
        connect(m_Timer, SIGNAL(timeout()), this, SLOT(executeCommand()));
    }
    LsText::applySettings();
}

void LsTextCommand::stopUpdate()
{
    if (m_Timer)
        m_Timer->stop();
}

void LsTextCommand::startUpdate()
{
    if (m_Timer)
        m_Timer->start();
    else
        executeCommand();
}

void LsTextCommand::executeCommand()
{
    if (m_Command.isEmpty())
        return;

    if (m_Process != NULL)
        return;

    qDebug() << "Executing external command:" << m_Command;

    QStringList args = QStringList() << "-c" << m_Command;
    m_Process = new QProcess(this);
    connect(m_Process, SIGNAL(finished(int,QProcess::ExitStatus)), this, SLOT(onProcessFinished(int,QProcess::ExitStatus)));
    m_Process->start("sh", args, QIODevice::ReadOnly);
    if (LockScreen::ScreenshotMode)
        m_Process->waitForFinished();
}

void LsTextCommand::onProcessFinished(int exitCode, QProcess::ExitStatus)
{
    if (exitCode == 0){
        m_Text = QString::fromUtf8(m_Process->readAll());
        qDebug() << "External command output:" << m_Text;
    }else{
        m_Text = QString(tr("Error: %1").arg(exitCode));
        qDebug() << "  Process exited with code" << m_Process->exitCode();
    }
    update();

    disconnect(m_Process, SIGNAL(finished(int,QProcess::ExitStatus)), this, SLOT(onProcessFinished(int,QProcess::ExitStatus)));
    m_Process->close();
    m_Process->deleteLater();
    m_Process = NULL;

}
