//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsoperatorname.h"
#include "lockscreen.h"

LsOperatorName::LsOperatorName(QString name) :
        LsWidget(name.isEmpty() ? "Operator": name)
{
    applySettings();

#ifdef Q_WS_MAEMO_5
    if (LockScreen::Debug)
        m_OperatorName = "Operator Name";
#else
    m_OperatorName = "Operator Name";
    setImage();
#endif
}


void LsOperatorName::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                           QWidget*)
{
    painter->setClipRect(option->exposedRect);

    if (!m_Image.isNull()){
        int x = 0;
        int y = 0;
        if ((m_Alignment & Qt::AlignVCenter) == Qt::AlignVCenter)
            y = size().height() / 2 - m_Image.height() / 2;
        else if ((m_Alignment & Qt::AlignBottom) == Qt::AlignBottom)
            y = size().height() - m_Image.height();

        if ((m_Alignment & Qt::AlignHCenter) == Qt::AlignHCenter)
            x = size().width() / 2 - m_Image.width() / 2;
        else if ((m_Alignment & Qt::AlignRight) == Qt::AlignRight)
            x = size().width() - m_Image.width();
        painter->drawPixmap(x,y,m_Image);
    }else if (!m_OperatorName.isEmpty()){
        painter->setFont(m_Font);
        painter->setPen(m_Color);
        painter->drawText(boundingRect(), m_Alignment | Qt::TextSingleLine, m_OperatorName);
    }
}

void LsOperatorName::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter, Qt::AlignVCenter);
    m_Color = getColorSetting("Color", QColor(255,255,255));
    m_Font = getFontSetting("Font", QFont("", 14, QFont::Normal, false));

    m_Images.clear();
    QString images = getSetting("Images", "").toString();
    QStringList lst = images.split(";", QString::SkipEmptyParts);
    foreach (const QString image, lst){
        QStringList ele = image.split("=", QString::SkipEmptyParts);
        if (ele.count() >= 2){
            m_Images[ele.at(0)] = ele.at(1);
        }
    }

    setSizeAndPosition(QSize(100, 20), QPoint(0, 0));
}

void LsOperatorName::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!LockScreen::Debug)
        getOpetorName();
    QDBusConnection::systemBus().connect("", "/com/nokia/phone/net", "Phone.Net",
                                         "operator_name_change", this, SLOT(onOperatorNameChanged(QDBusMessage)));
#endif
}

void LsOperatorName::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().disconnect("", "/com/nokia/phone/net", "Phone.Net",
                                            "operator_name_change", this, SLOT(onOperatorNameChanged(QDBusMessage)));
#endif
}

#ifdef Q_WS_MAEMO_5
void LsOperatorName::onOperatorNameChanged(QDBusMessage msg)
{
    if (msg.arguments().count() > 1){
        QVariant val = msg.arguments()[1];
        QString name = val.toString();
        if (name != m_OperatorName){
            qDebug() << "Operator name changed" << name;
            m_OperatorName = name;
            setImage();
            update();
        }
    }
}
#endif

void LsOperatorName::getOpetorName()
{
#ifdef Q_WS_MAEMO_5
    QDBusInterface device(QLatin1String("com.nokia.phone.net"),
                          QLatin1String("/com/nokia/phone/net"),
                          QLatin1String("Phone.Net"),
                          QDBusConnection::systemBus());
    qDebug() << "com.nokia.phone.net::get_registration_status";
    QDBusMessage msg = device.call(QLatin1String("get_registration_status"));
    if (msg.type() == QDBusMessage::ErrorMessage)
        qWarning() << msg.errorMessage();
    else{
        if (msg.arguments().count() > 4){
            uint opCode = msg.arguments().at(3).toInt();
            uint countryCode = msg.arguments().at(4).toInt();
            qDebug() << "OpCode:" << opCode << "CountryCode:" << countryCode;
            qDebug() << "com.nokia.phone.net::get_operator_name";

            msg = device.call(QLatin1String("get_operator_name"), QVariant::fromValue(uchar(0)), opCode, countryCode);
            if (msg.type() == QDBusMessage::ErrorMessage)
                qWarning() << msg.errorMessage();
            else{
                if (msg.arguments().count() > 0){
                    QString name = msg.arguments().at(0).toString();
                    if (name != m_OperatorName){
                        qDebug() << "Operator name changed" << name;
                        m_OperatorName = name;
                        setImage();
                        update();
                    }
                }
            }
        }
    }
#endif
}

void LsOperatorName::setImage()
{
    if (m_Images.contains(m_OperatorName)){
        QString file = m_Images[m_OperatorName];
        m_Image = QPixmap(file);
    }
}
