#include "systemprofiles.h"

SystemProfiles::SystemProfiles(QObject *parent) :
    QObject(parent)
{
    profile_track_add_profile_cb(profileChanged_cb, this, NULL);
}

QStringList SystemProfiles::profilesList()
{
    QStringList list;
#ifdef Q_WS_MAEMO_5
    char** profiles = profile_get_profiles();
    for (unsigned i = 0; profiles[i] != 0; i++) {
        list.append(profiles[i]);
    }
#endif
    return list;
}

QString SystemProfiles::currentProfile()
{
#ifdef Q_WS_MAEMO_5
    return QString::fromUtf8(profile_get_profile());
#else
    return QString();
#endif
}

void SystemProfiles::setProfile(QString profileName)
{
#ifdef Q_WS_MAEMO_5
    profile_set_profile(profileName.toUtf8());
#else
    Q_UNUSED(profileName)
#endif
}

void SystemProfiles::profileChanged_cb(const char *profile, void *user_data)
{
    //qDebug() << "profileChanged_cb:" << profile;
    emit static_cast<SystemProfiles*>(user_data)->profileChanged(QString::fromUtf8(profile));
}
