#include "systemplayer.h"

SystemPlayer::SystemPlayer(QObject *parent) :
    QObject(parent)
{
#ifdef Q_WS_MAEMO_5
    m_state = SystemPlayer::UnknownState;
    m_renderer = new MafwRendererAdapter();
    m_Playlist = new MafwPlaylistAdapter(this, m_renderer);
    m_Tracker = new MafwSourceAdapter("Mafw-Tracker-Source");

    connect(m_Tracker, SIGNAL(signalMetadataResult(QString,GHashTable*,QString)), this, SLOT(onGotMafwTrackerMetadata(QString,GHashTable*,QString)));
    connect(m_Playlist, SIGNAL(playlistChanged()), this, SLOT(onPlaylistChanged()));
    connect(m_renderer, SIGNAL(signalGetPosition(int,QString)), this, SLOT(onGotPosition(int,QString)));
    connect(m_renderer, SIGNAL(mediaChanged(int,char*)), this, SLOT(mafwMediaChanged(int,char*)));
    connect(m_renderer, SIGNAL(stateChanged(int)), this, SLOT(mafwStateChanged(int)));
    connect(m_renderer, SIGNAL(signalGetStatus(MafwPlaylist*,uint,MafwPlayState,const char*,QString)),
            this, SLOT(onGotMafwState(MafwPlaylist*,uint,MafwPlayState,const char*,QString)));
    connect(m_renderer, SIGNAL(signalGetCurrentMetadata(GHashTable*,QString,QString)),
            this, SLOT(onGotMafwMetadata(GHashTable*,QString,QString)));
    connect(m_renderer, SIGNAL(metadataChanged(QString,QVariant)), m_renderer, SLOT(getCurrentMetadata()));
    if (m_renderer->isRendererReady()) {
        m_renderer->getStatus();
        m_renderer->getCurrentMetadata();
    } else {
        connect(m_renderer, SIGNAL(rendererReady()), m_renderer, SLOT(getStatus()));
        connect(m_renderer, SIGNAL(rendererReady()), m_renderer, SLOT(getCurrentMetadata()));
    }
#endif
}

void SystemPlayer::play()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->play();
#endif
}

void SystemPlayer::resume()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->resume();
#endif
}

void SystemPlayer::pause()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->pause();
#endif
}

void SystemPlayer::stop()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->stop();
#endif
}

void SystemPlayer::next()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->next();
#endif
}

void SystemPlayer::previous()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->previous();
#endif
}

void SystemPlayer::getPosition()
{
#ifdef Q_WS_MAEMO_5
    m_renderer->getPosition();
#endif
}

void SystemPlayer::getCurrentMetadata()
{
#ifdef Q_WS_MAEMO_5
    qDebug() << "getCurrentMetadata:" << m_state << m_ObjectId;
    if (!m_ObjectId.isEmpty() &&
        (m_state == SystemPlayer::StoppedState || m_state == SystemPlayer::UnknownState))
        mafwMediaChanged(0, m_ObjectId.toUtf8().data());
    else
        m_renderer->getCurrentMetadata();
#endif
}

SystemPlayer::PlaybackState SystemPlayer::state()
{
    return m_state;
}

#ifdef Q_WS_MAEMO_5
void SystemPlayer::onGotPosition(int position, QString error)
{
    qDebug() << "Got position:" << position;
    emit gotPosition(position, error);
}

void SystemPlayer::mafwStateChanged(int mafwState)
{
    if (m_mafwState == mafwState)
        return;

    m_mafwState = mafwState;

    SystemPlayer::PlaybackState oldState = m_state;
    switch (mafwState) {
    case Playing:
        m_state = SystemPlayer::PlayingState;
        break;
    case Paused:
        m_state = SystemPlayer::PausedState;
        break;
    case Stopped:
        m_state = SystemPlayer::StoppedState;
        break;
    case Transitioning:
        break;
    case _LastMafwPlayState:
        break;
    }

    if (oldState != m_state)
        emit stateChanged(m_state);
}

void SystemPlayer::onGotMafwState(MafwPlaylist*, uint, MafwPlayState state, const char* objectId, QString)
{
    qDebug() << "onGotMafwState: objectId" << objectId;

    bool update = m_ObjectId.isEmpty();

    m_ObjectId = QString::fromUtf8(objectId);
    this->mafwStateChanged(state);
    if (update)
        getCurrentMetadata();
}

void SystemPlayer::onGotMafwMetadata(GHashTable* table,QString,QString)
{
    QMap <QString, QVariant> metadata;
    GValue *v;
    v = mafw_metadata_first(table, MAFW_METADATA_KEY_ARTIST);
    QString artist = v ? QString::fromUtf8(g_value_get_string(v)) : tr("Unknown artist");

    v = mafw_metadata_first(table, MAFW_METADATA_KEY_TITLE);
    QString songName = v ? QString::fromUtf8(g_value_get_string(v)) : tr("Unknown song");

    v = mafw_metadata_first(table, MAFW_METADATA_KEY_ALBUM);
    QString album = v ? QString::fromUtf8(g_value_get_string(v)) : tr("Unknown album");

    QString art = "";
    v = mafw_metadata_first(table, MAFW_METADATA_KEY_RENDERER_ART_URI);
    if(v != NULL) {
        art = QString::fromUtf8(g_value_get_string(v));
        qDebug() << "MAFW_METADATA_KEY_ALBUM_ART_URI:" << art;
    } else {
        v = mafw_metadata_first(table, MAFW_METADATA_KEY_ALBUM_ART_URI);
        if(v != NULL) {
            const gchar* file_uri = g_value_get_string(v);
            gchar* filename = g_filename_from_uri(file_uri, NULL, NULL);
            art = QString::fromUtf8(filename);
            qDebug() << "MAFW_METADATA_KEY_ALBUM_ART_URI:" << art;
        }
    }

    metadata.insert(SYSTEM_PLAYER_SONG_TITLE, songName);
    metadata.insert(SYSTEM_PLAYER_SONG_ALBUM, album);
    metadata.insert(SYSTEM_PLAYER_SONG_ARTIST, artist);
    metadata.insert(SYSTEM_PLAYER_ALBUM_ART, art);

    emit metadataChanged(metadata);
}

void SystemPlayer::onPlaylistChanged()
{
    qDebug() << "Playlist changed";
}

void SystemPlayer::mafwMediaChanged(int, char* objectId)
{
    qDebug() << "Media changed:" << objectId;
    m_ObjectId = QString::fromUtf8(objectId);
    m_Tracker->getMetadata(objectId, MAFW_SOURCE_LIST(MAFW_METADATA_KEY_TITLE,
                           MAFW_METADATA_KEY_ALBUM,
                           MAFW_METADATA_KEY_ARTIST,
                           MAFW_METADATA_KEY_ALBUM_ART_URI,
                           MAFW_METADATA_KEY_RENDERER_ART_URI));
}

void SystemPlayer::onGotMafwTrackerMetadata(QString objectId, GHashTable* metadata_keys, QString error)
{
    onGotMafwMetadata(metadata_keys, objectId, error);
}

#endif

