//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lswifi.h"
#include "lockscreen.h"

LsWifi::LsWifi(QString name) :
        LsWidget(name.isEmpty() ? "Internet": name)
{
    m_Connected = false;
    applySettings();
#ifdef Q_WS_MAEMO_5
    if (LockScreen::Debug){
        m_Image = QPixmap(m_Wifi);
        m_Connected = true;
    }
#else
    m_Image = QPixmap(m_Wifi);
    m_Connected = true;
#endif
}

void LsWifi::paint(QPainter *painter, const QStyleOptionGraphicsItem* option,
                   QWidget *)
{
    painter->setClipRect(option->exposedRect);
    if (m_Connected && !m_Image.isNull()){
        painter->drawPixmap(0,0,m_Image);
    }
}

void LsWifi::applySettings()
{
    QString wifiImage = getSetting("Image", "").toString(); //old setting for compatibility with themes
    if (wifiImage.isEmpty())
        wifiImage = getSetting("WifiImage", "/opt/qtlockscreen/default/wifi.png").toString();
    m_Wifi = wifiImage;
    m_Gprs = getSetting("GprsImage", "/opt/qtlockscreen/default/gprs.png").toString();

    setSizeAndPosition(QSize(48, 48), QPoint(0, 0));
}


void LsWifi::netStateChanged(QString, QString type, QString state, QString)
{
    qDebug() << QString("Network status changed: %1 %2").arg(type).arg(state);
    if (type == "WLAN_INFRA" || type == "GPRS"){
        m_Connected = state == "CONNECTED";

        if (m_Connected){
            if (type == "WLAN_INFRA")
                m_Image = QPixmap(m_Wifi);
            else
                m_Image = QPixmap(m_Gprs);
        }else
            m_Image = QPixmap();
        update();
    }
}

void LsWifi::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    //if (!LockScreen::Debug)
        getNetworkState();
    QDBusConnection::systemBus().connect("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd",
                                         "status_changed", this, SLOT(netStateChanged(QString,QString,QString,QString)));
#endif
}

void LsWifi::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().disconnect("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd",
                                            "status_changed", this, SLOT(netStateChanged(QString,QString,QString,QString)));
#endif
}

void LsWifi::getNetworkState()
{
    QProcess p;
    p.setReadChannelMode(QProcess::MergedChannels);
    p.start("/opt/qtlockscreen/internetwidget.sh");
    p.waitForFinished(-1);

    QString res = p.readAll().trimmed();
    qDebug() << "Network state:" << res;

    if (res == "wlan0"){
        m_Image = QPixmap(m_Wifi);
        m_Connected = true;
    }else if (res == "gprs0"){
        m_Image = QPixmap(m_Gprs);
        m_Connected = true;
    }else{
        m_Image = QPixmap();
        m_Connected = false;
    }
    update();
}
