//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmediatimelabel.h"
#include <QTime>
LsMediaTimeLabel::LsMediaTimeLabel(QString name, SystemPlayer* player) :
        LsWidget(name.isEmpty() ? "MediaTimeLabel": name)
{
    m_Player = player;
    m_Position = 0;

    m_Timer.setInterval(1000);
    m_Timer.setSingleShot(false);
    connect(&m_Timer, SIGNAL(timeout()), this, SLOT(onTimer()));
    applySettings();
}

void LsMediaTimeLabel::paint(QPainter *painter, const QStyleOptionGraphicsItem* option,
                            QWidget*)
{
    painter->setClipRect(option->exposedRect);
    QTime t(0,0,0);
    t = t.addSecs(m_Position);

    QString time = t.hour() > 0 ? t.toString("hh:mm:ss") : t.toString("mm:ss");
    QRectF rect(boundingRect());

    painter->setFont(m_Font);
    painter->setPen(m_Color);
    painter->drawText(rect, Qt::AlignTop | Qt::AlignHCenter | Qt::TextSingleLine, time);
}

void LsMediaTimeLabel::applySettings()
{
    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));

    m_Color = getColorSetting("Color", QColor(255,255,255));
    m_Font = getFontSetting("Font", QFont("", 10, QFont::Normal, false));
}

void LsMediaTimeLabel::stopUpdate()
{
    m_Timer.stop();
    if (m_Player){
        disconnect(m_Player, SIGNAL(stateChanged(SystemPlayer::PlaybackState)), this, SLOT(onPlayerStateChanged(SystemPlayer::PlaybackState)));
        disconnect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
        disconnect(m_Player, SIGNAL(gotPosition(int,QString)), this, SLOT(onGotPosition(int,QString)));
    }
}

void LsMediaTimeLabel::startUpdate()
{
    if (m_Player){
        connect(m_Player, SIGNAL(stateChanged(SystemPlayer::PlaybackState)), this, SLOT(onPlayerStateChanged(SystemPlayer::PlaybackState)));
        connect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
        connect(m_Player, SIGNAL(gotPosition(int,QString)), this, SLOT(onGotPosition(int,QString)));
        onPlayerStateChanged(m_Player->state());
    }
}

void LsMediaTimeLabel::onGotPosition(int position, QString)
{
    qDebug() << "Got position" << position;
    m_Position = position;
    update();
}

void LsMediaTimeLabel::onMetadataChanged(QMap<QString,QVariant>)
{
    m_Position = 0;
    m_Player->getPosition();
}

void LsMediaTimeLabel::onPlayerStateChanged(SystemPlayer::PlaybackState state)
{
    if (state == SystemPlayer::PlayingState){
        if (!m_Timer.isActive())
            m_Timer.start();
    }else
        m_Timer.stop();

    m_Player->getPosition();
}

void LsMediaTimeLabel::onTimer()
{
    m_Position++;
    update();
}
