//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSBATTERY_H
#define LSBATTERY_H
#include "lswidget.h"

class LsBattery : public QObject, public LsWidget
{
    Q_OBJECT
public:
    enum PercSource
    {
        SourceDefault = 0,
        SourceBq27200,
        SourceDrFrost,
    };

    LsBattery(QString name="");

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget);
    void stopUpdate();
    void startUpdate();
    void applySettings();

private:
    PercSource m_PercSource;
    bool m_IsCharging;
    float m_Percentage;
    QList<QPixmap> m_Images;
    QPixmap m_ChargingImage;
    QFont m_PercFont;
    QColor m_PercColor;

    float GetValue(QString file);

private slots:
#ifdef Q_WS_MAEMO_5
    void bmePropertyModifiedSlot(QDBusMessage);
#endif
};

#endif // LSBATTERY_H
