#include "systemprofiles.h"

SystemProfiles::SystemProfiles(QObject *parent) :
    QObject(parent)
{
}

QStringList SystemProfiles::profilesList()
{
    QStringList list;
#ifdef Q_WS_MAEMO_5
    char** profiles = profile_get_profiles();
    for (unsigned i = 0; profiles[i] != 0; i++) {
        list.append(profiles[i]);
    }
#endif
    return list;
}

QString SystemProfiles::currentProfile()
{
#ifdef Q_WS_MAEMO_5
    return QString::fromUtf8(profile_get_profile());
#else
    return QString();
#endif
}

void SystemProfiles::setProfile(QString profileName)
{
#ifdef Q_WS_MAEMO_5
    profile_set_profile(profileName.toUtf8());
#else
    Q_UNUSED(profileName)
#endif
}
