//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lswifi.h"
#include "lockscreen.h"

LsWifi::LsWifi(QString name) :
        LsWidget(name.isEmpty() ? "Wifi": name)
{
    m_Connected = false;
    applySettings();
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().connect("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd",
                                         "status_changed", this, SLOT(netStateChanged(QString,QString,QString,QString)));

    if (LockScreen::Debug)
        m_Connected = true;
#else
    m_Connected = true;
#endif
}

void LsWifi::paint(QPainter *painter, const QStyleOptionGraphicsItem *,
                   QWidget *)
{
    if (m_Connected && !m_Image.isNull()){
        painter->drawPixmap(0,0,m_Image);
    }
}

void LsWifi::applySettings()
{
    m_Image = QPixmap(getSetting("Image", "/opt/qtlockscreen/default/wifi.png").toString());
    setSizeAndPosition(QSize(48, 48), QPoint(0, 0));
}


void LsWifi::netStateChanged(QString, QString type, QString state, QString)
{
    qDebug() << QString("Network status changed: %1 %2").arg(type).arg(state);
    if (type == "WLAN_INFRA" || type == "GPRS"){
        m_Connected = state == "CONNECTED";
        update();
    }
}
