//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef LSWIDGET_H
#define LSWIDGET_H

#include <QGraphicsItem>
#include <QStyleOptionGraphicsItem>
#include <QPainter>
#include <QGraphicsScene>
#include <QSettings>
#include <QStringList>
#include <QDebug>
#ifdef Q_WS_MAEMO_5
    #include <QDBusInterface>
    #include <QDBusMessage>
#endif

#define MINIMUM_TEXT_MARGIN 2

class LsWidget : public QGraphicsItem
{
public:
    enum Orientation
    {
        Auto,
        Portrait,
        Landscape,
    };

    LsWidget(QString name);
    ~LsWidget() {}

    QRectF boundingRect() const;
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                       QWidget *widget) = 0;

    virtual void stopUpdate() {}
    virtual void startUpdate() {}
    virtual void applySettings() {}

    static bool isPortrait();
    static LsWidget::Orientation getOrientation();
    static void setOrientation(LsWidget::Orientation);

    virtual void onOrientationChanged() {}
    void setSizeAndPosition(QSize defaultSize, QPoint defaultPos);
    void setName(QString name);
    QString name();
    QRectF size();
    QRectF sceneRect();
    void update();

protected:
    QVariant getSetting(QString name, QVariant defaultValue);
    QPoint getPosSetting(QString name, QPoint defaultValue);
    QPoint getPosSetting(QPoint defaultValue);
    QSize getSizeSetting(QSize defaultValue);
    QSize getSizeSetting(QString name, QSize defaultValue);
    QColor getColorSetting(QString name, QColor defaultValue);
    Qt::AlignmentFlag getAlignmentSetting(QString name, Qt::AlignmentFlag defaultValue);
    QFont getFontSetting(QString name, QFont defaultValue);

    void setSize(QSize);

private:
    //static bool m_Portrait;
    static Orientation m_Orientation;

    QString m_Name;
    QRectF m_Size;
};

#endif // LSWIDGET_H
