//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsslidetounlock.h"
#include <QApplication>
#include "lockscreen.h"

LsSlideToUnlock::LsSlideToUnlock(QString name) :
        LsWidget(name.isEmpty() ? "SlideToUnlock": name)
{
    m_Slider = new LsUnlockSlider("UnlockSlider");
    connect(m_Slider, SIGNAL(moveEnded()), this, SLOT(onSliderMoveEnded()));
    connect(m_Slider, SIGNAL(moved(QPointF)), this, SLOT(onSliderMoved(QPointF)));

    m_Slider->setParentItem(this);
    m_Slider->setPos(0,0);
    applySettings();
}

void LsSlideToUnlock::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                            QWidget*)
{
    if (!m_BackgroundImage.isNull()){
        painter->drawPixmap(0,0,m_BackgroundImage);
    }
}

void LsSlideToUnlock::applySettings()
{
    m_SliderInitialPos = getPosSetting("SliderPos", QPoint(0,0));
    m_Slider->setImage(QPixmap(getSetting("SliderImage", "/opt/qtlockscreen/default/unlock.png").toString()));
    m_Slider->setPressedImage(QPixmap(getSetting("SliderImagePressed", "").toString()));
    m_Slider->setPos(m_SliderInitialPos);
    m_BackgroundImage = QPixmap(getSetting("BackgroundImage", "").toString());

    //m_UnlockX = getSetting("UnlockX", -1).toInt();
    //m_UnlockY = getSetting("UnlockY", -1).toInt();
    m_UnlockX = -1;
    m_UnlockY = -1;
    onOrientationChanged();
    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));
}

void LsSlideToUnlock::onSliderMoveEnded()
{
    QPointF pos = m_Slider->pos();
    QPropertyAnimation *ran = new QPropertyAnimation(m_Slider, "pos");
    ran->setEasingCurve(QEasingCurve::InOutCubic);
    ran->setStartValue(pos);
    ran->setEndValue(m_SliderInitialPos);
    ran->start(QAbstractAnimation::DeleteWhenStopped);
}

void LsSlideToUnlock::onSliderMoved(QPointF pos)
{    
    if ((m_SliderInitialPos.x() < m_UnlockX && pos.x() >= m_UnlockX) ||
        (m_SliderInitialPos.x() > m_UnlockX && pos.x() <= m_UnlockX) ||
        (m_SliderInitialPos.y() < m_UnlockY && pos.y() >= m_UnlockY) ||
        (m_SliderInitialPos.y() > m_UnlockY && pos.y() <= m_UnlockY)) {
        qDebug() << "SlideToUnlock triggered";
    #ifdef Q_WS_MAEMO_5
        QDBusInterface lockScreen("com.nokia.mce", "/com/nokia/mce/request", "com.nokia.mce.request", QDBusConnection::systemBus(), this);
        lockScreen.call("req_tklock_mode_change", "unlocked");
        mouseReleaseEvent(new QGraphicsSceneMouseEvent());
        if (LockScreen::Debug)
            qApp->quit();
    #else
        qApp->quit();
    #endif
    }
}

void LsSlideToUnlock::onOrientationChanged()
{
    if (LsWidget::isPortrait()){
        m_UnlockX = getSetting("UnlockXP", m_UnlockX).toInt();
        m_UnlockY = getSetting("UnlockYP", m_UnlockY).toInt();
    }else{
        m_UnlockX = getSetting("UnlockXL", m_UnlockX).toInt();
        m_UnlockY = getSetting("UnlockYL", m_UnlockY).toInt();
    }
}
