//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsmediametadata.h"

LsMediaMetadata::LsMediaMetadata(QString name, SystemPlayer* player) :
        LsWidget(name.isEmpty() ? "MediaMetadata": name)
{
    m_Player = player;
    applySettings();
}

void LsMediaMetadata::paint(QPainter *painter, const QStyleOptionGraphicsItem*,
                            QWidget*)
{
    QString title = m_Metadata.value(SYSTEM_PLAYER_SONG_TITLE).toString();
    if (title.isEmpty())
        title = tr("Unknown title");

    QString artist = m_Metadata.value(SYSTEM_PLAYER_SONG_ARTIST).toString();
    if (artist.isEmpty())
        artist = tr("Unknown artist");

    QRectF rect(boundingRect());

    painter->setFont(m_TitleFont);
    painter->setPen(m_TitleColor);
    painter->drawText(rect, Qt::AlignTop | m_Alignment | Qt::TextSingleLine, title);

    QFontMetrics fm(m_TitleFont);
    QSize size = fm.size(Qt::TextSingleLine, title);
    rect.setTop(rect.top() + size.height() + MINIMUM_TEXT_MARGIN);

    painter->setFont(m_ArtistFont);
    painter->setPen(m_ArtistColor);
    painter->drawText(rect, Qt::AlignTop | m_Alignment | Qt::TextSingleLine, artist);
}

void LsMediaMetadata::applySettings()
{
    m_Alignment = getAlignmentSetting("Alignment", Qt::AlignHCenter);
    m_TitleColor = getColorSetting("TitleColor", QColor(255,255,255));
    m_ArtistColor = getColorSetting("ArtistColor", QColor(255,255,255));

    m_TitleFont = QFont();
    m_TitleFont.setPointSize(getSetting("TitleFontSize", 20).toInt());
    m_ArtistFont = QFont();
    m_ArtistFont.setPointSize(getSetting("ArtistFontSize", 15).toInt());

    setSizeAndPosition(QSize(100, 100), QPoint(0, 0));
}

void LsMediaMetadata::stopUpdate()
{
    if (m_Player){
        disconnect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
    }
}

void LsMediaMetadata::startUpdate()
{
    if (m_Player){
        connect(m_Player, SIGNAL(metadataChanged(QMap<QString,QVariant>)), this, SLOT(onMetadataChanged(QMap<QString,QVariant>)));
        if (m_Player->state() == SystemPlayer::UnknownState ||
            m_Player->state() == SystemPlayer::StoppedState){

        }
    }
}

void LsMediaMetadata::onMetadataChanged(QMap<QString,QVariant> data)
{
    qDebug() << "Metadata changed";
    m_Metadata = data;
    update();
}
