#ifndef LAYOUTWIDGET_H
#define LAYOUTWIDGET_H

#include <QtGui>
#include <QString>
#include <QWidget>
#include <QImage>
#include <QMainWindow>
#include <QPainter>
#include <QVector>
#include "buttonwidget.h"
#include "newbuttondlg.h"
#include "socket.h"


class QDragEnterEvent;
class QDropEvent;
class ButtonWidget;
class NewButtonDlg;

class LayoutWidget: public QWidget
{
    Q_OBJECT

public:
    //! Constructor.
    explicit LayoutWidget(QMainWindow *parent );
    //! Destructor.
    virtual ~LayoutWidget();
    //! Current background path.
    QString bgPath;
    //! Current background mode.
    int backgroundMode;
    //! Selected button index in vector.
    int currentButtonIndex;
    //! Methods to add button to layout.
    void addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int aNumber);
    void addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, QPoint position, int timeOut);
    //! Sets using mode enabled or disabled.
    void setUseModeEnabled(bool useMode);
    //! Socket for sending Lirc commands.
    Socket *socket;
    //! Vector for all buttons on layout.
    QVector<ButtonWidget*> *vector;
    //! Boolean to tell if snap to grid enabled.
    bool snapToGridEnabled;

private:
    NewButtonDlg *newButtonDlg;
    QDialog *deleteButtonDlg;
    //! Boolean to tell if using mode enabled or disabled.
    bool useModeEnabled;
    //! Background RGB values.
    QString r,g,b;
    //! Remote name for active remote.
    QString activeRemoteName;
    //! Count for buttons.
    int number;
    //! Copy of button used in drag/drop.
    ButtonWidget *newButton;
    //! Button position.
    int xPos,yPos;
    //! Timer for sending lirc commands in a row.
    QTimer *timer;
    //! Extra buttonwidget for sending lirc commands.
    ButtonWidget *copyButton;
    //! Timer when multiple commands in one button.
    QTimer *timer2;
    //! Timer2 timeout time.
    int timeout2;
    //! Index of commandchain used by timer2.
    int timer2Index;


protected:
    void mousePressEvent(QMouseEvent *event);
    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dropEvent(QDropEvent *event);

signals:

public slots:
    //! Saves remote to file.
    void saveRemoteToFile();
    //! Opens new button dialog.
    void openEditDlg();
    //! Opens new button dialog but used for editing existing button.
    void editButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number, int timeOut);
    //! Slot to change current background mode.
    void setBackgroundMode(int mode);
    //! Slot to set RGB values and mode.
    void setRgbValues(QString red,QString green,QString blue);
    //! Slot to set active remote name.
    void setActiveRemoteName(QString activeRemote);
    //! Slot to set integer values of RGB.
    void setRgbInteger(int aR,int aG,int aB);
    //! Slot to set background image path.
    void setBackgroundImagePath(QString bgImagePath);
    //! Slot to clear LayoutWidget from buttons.
    void clearScreen();
    //! Arrange buttons properly
    void snapToGrid();

private slots:
    //! Slot called when button pressed and it has command.
    void sendIrCommands(QStringList commands);
    //! Slot called when delete button in button menu clicked.
    void deleteButton();
    //! Dialog to ask if user really wants to delete button.
    void confirmDelete();
    //! Timer slot.
    void sendIrCommandsSlot();
    //! Timer2 slot.
    void sendMultipleIrCommandsSlot();
};
#endif // LAYOUTWIDGET_H
