#include "newbuttondlg.h"
#include "ui_newbuttondlg.h"

#include <QMessageBox>

NewButtonDlg::NewButtonDlg(QWidget *parent, QVector<ButtonWidget*> *vector) :
    QDialog(parent),
    m_ui(new Ui::NewButtonDlg)
{
    m_ui->setupUi(this);
    buttonTextToEmit.clear();
    editMode = false;
    buttons = vector;
    connect(m_ui->horizontalScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setTimeOut(int)));
    connect(m_ui->nameLineEdit,SIGNAL(textChanged(QString)),this,SLOT(allowCreatingButton()));
    m_ui->OkPushButton->setDisabled(true);
    m_ui->horizontalScrollBar->hide();
    m_ui->timeOutLabel->hide();
    m_ui->timeOutValueLabel->hide();
    this->addPreviewImage(defaultButtonsPath+"blank/unpressed.png",defaultButtonsPath+"blank/pressed.png",
                          defaultButtonsPath+"blank/button.conf");

}

NewButtonDlg::NewButtonDlg(QWidget *parent, ButtonWidget *child, QVector<ButtonWidget*> *vector) :
    QDialog(parent),
    m_ui(new Ui::NewButtonDlg)
{
    m_ui->setupUi(this);
    buttonTextToEmit.clear();
    editMode = true;
    buttons = vector;
    button = child;
    connect(m_ui->horizontalScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setTimeOut(int)));
    connect(m_ui->nameLineEdit,SIGNAL(textChanged(QString)),this,SLOT(allowCreatingButton()));
    m_ui->horizontalScrollBar->hide();
    m_ui->timeOutLabel->hide();
    m_ui->timeOutValueLabel->hide();
    this->addPreviewImage(child->fileNameUnPressed,child->fileNamePressed,child->confFileName);
    m_ui->nameLineEdit->setText(QString(child->buttonText));
    for(int i= 0;i<child->commandChain.size();i++)
        m_ui->commandChainList->insertItem(i,child->commandChain.at(i));
    if(child->commandChain.count() > 1) {
         m_ui->horizontalScrollBar->show();
         m_ui->timeOutLabel->show();
         m_ui->timeOutValueLabel->show();
         m_ui->horizontalScrollBar->setValue(child->timeOut/100);
         QString str;
         str.setNum(child->timeOut);
         m_ui->timeOutValueLabel->setText(str+"ms");
    }
}

NewButtonDlg::~NewButtonDlg()
{
    delete pix;
    delete m_ui;
}


void NewButtonDlg::on_OkPushButton_clicked()
{
    bool buttonNameExists = false;
    timeOut = m_ui->horizontalScrollBar->value()*100;
    if(editMode)
        button->timeOut = timeOut;

    for(int i= 0;i<m_ui->commandChainList->count();i++)
        commandChain.append(m_ui->commandChainList->item(i)->text());

    buttonTextToEmit = m_ui->nameLineEdit->text();
    if(!editMode) {
        for(int i=0; i<buttons->count(); i++) {
            if(buttons->at(i)->buttonText == buttonTextToEmit) {
                    buttonNameExists = true;
                    QMessageBox::warning(this,"Button name already exists","Please change button name! ",
                         QMessageBox::NoButton,QMessageBox::NoButton);
                    break;
                }
        }
    }
    else {
         for(int i=0; i<buttons->count(); i++) {
            if(buttons->at(i)->buttonText == buttonTextToEmit && buttonTextToEmit!=button->buttonText ) {
                    buttonNameExists = true;
                    QMessageBox::warning(this,"Button name already exists","Please change button name! ",
                         QMessageBox::NoButton,QMessageBox::NoButton);
                    break;
                }
        }
    }

      if(m_ui->nameLineEdit->text().isEmpty())
            QMessageBox::information(this,"Button name","Please enter button name.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
      else  {
            if(!buttonNameExists) {
                emit addButtonToLayoutSignal(fileNameUnPressedToEmit, fileNamePressedToEmit, confFileNameToEmit, buttonTextToEmit, commandChain,0, timeOut );
                this->close();
            }

        }
}

void NewButtonDlg::on_styleChangePushButton_clicked()
{
    bsDlg = new ButtonSelectDlg(this);
    connect(bsDlg,SIGNAL(signalAddButton(QString, QString, QString)),this,SLOT(addPreviewImage(QString, QString, QString)));
    bsDlg->exec();
}

void NewButtonDlg::addPreviewImage(QString fileNameUnPressed, QString fileNamePressed, QString confFileName)
{
    pix = new QPixmap(fileNameUnPressed);
    m_ui->styleLabel->setPixmap(pix->scaled(128,128,Qt::KeepAspectRatio,Qt::FastTransformation));
    m_ui->styleLabel->setAlignment(Qt::AlignCenter);
    m_ui->OkPushButton->setEnabled(true);

    fileNameUnPressedToEmit = fileNameUnPressed;
    fileNamePressedToEmit = fileNamePressed;
    confFileNameToEmit = confFileName;

    QFile file(confFileName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;

     QTextStream in(&file);
     while (!in.atEnd()) {
         QString line = in.readLine();
         process_line(line);
     }
}

void NewButtonDlg::process_line(QString line)
{
    if(line.contains(("name="), Qt::CaseInsensitive) && line.startsWith("n", Qt::CaseInsensitive)) {
        QString x = line;
        QString name;
        int count;
        int chars;
        count = line.length();
        chars = count - 5;
        name = x.right(chars);
        m_ui->nameLineEdit->setText(name);
    }
}

void NewButtonDlg::mousePressEvent(QMouseEvent *event)
{
    if(event->pos().x() >= m_ui->styleLabel->pos().x() && event->pos().x() <= m_ui->styleLabel->pos().x() + m_ui->styleLabel->width()
        && event->pos().y() >= m_ui->styleLabel->pos().y() && event->pos().y() <= m_ui->styleLabel->pos().y() + m_ui->styleLabel->height())
    {
        ButtonSelectDlg *bsDlg = new ButtonSelectDlg(this);
        connect(bsDlg,SIGNAL(signalAddButton(QString, QString, QString)),this,SLOT(addPreviewImage(QString, QString, QString)));
        bsDlg->exec();
        delete bsDlg;
    }
}

void NewButtonDlg::on_addPushButton_clicked()
{
    ccDlg = new CommandChainDlg(this);
    connect(ccDlg,SIGNAL(signalAddCommand(QString,QString)),this,SLOT(getCommand(QString,QString)));
    ccDlg->exec();
}

void NewButtonDlg::getCommand(QString commandName,QString modelName)
{
    QListWidgetItem *item = new QListWidgetItem();
    item->setText(modelName+ " " + commandName);
    m_ui->commandChainList->insertItem(m_ui->commandChainList->count(),item);
    m_ui->nameLineEdit->setText(commandName);
    if(m_ui->commandChainList->count() > 1) {
        m_ui->horizontalScrollBar->show();
        m_ui->timeOutLabel->show();
        m_ui->timeOutValueLabel->show();
    }
}

void NewButtonDlg::on_removePushButton_clicked()
{
    delete m_ui->commandChainList->currentItem();
     if(m_ui->commandChainList->count() < 2) {
        m_ui->horizontalScrollBar->hide();
        m_ui->timeOutLabel->hide();
        m_ui->timeOutValueLabel->hide();
    }
}

void NewButtonDlg::on_upPushButton_clicked()
{
    QListWidgetItem *item;
    if(m_ui->commandChainList->currentRow()==m_ui->commandChainList->count()-1) {
        item = m_ui->commandChainList->takeItem(m_ui->commandChainList->currentRow());
        m_ui->commandChainList->insertItem(m_ui->commandChainList->currentRow(),item);
        m_ui->commandChainList->setCurrentRow(m_ui->commandChainList->currentRow()-1);
    }
    else {
        if(m_ui->commandChainList->currentRow()!=0) {
            item = m_ui->commandChainList->takeItem(m_ui->commandChainList->currentRow());
            m_ui->commandChainList->insertItem(m_ui->commandChainList->currentRow()-1,item);
            m_ui->commandChainList->setCurrentRow(m_ui->commandChainList->currentRow()-2);
        }
    }
}

void NewButtonDlg::on_downPushButton_clicked()
{
    QListWidgetItem *item;
    item = m_ui->commandChainList->takeItem(m_ui->commandChainList->currentRow());
    m_ui->commandChainList->insertItem(m_ui->commandChainList->currentRow()+1,item);
    m_ui->commandChainList->setCurrentRow(m_ui->commandChainList->currentRow()+1);
}
void NewButtonDlg::setTimeOut(int timeValue)
{
    QString str;
    str.setNum(timeValue*100);
    m_ui->timeOutValueLabel->setText(str+"ms");

}
void NewButtonDlg::allowCreatingButton()
{
    if(m_ui->nameLineEdit->text().isEmpty())
        m_ui->OkPushButton->setDisabled(true);
    else m_ui->OkPushButton->setEnabled(true);
}
