#ifndef REMOTESTARTUPDLG_H
#define REMOTESTARTUPDLG_H

#include <QtGui/QDialog>
#include <QDir>
#include <QTextStream>
#include <QPushButton>
#include <QListWidgetItem>
#include <QMessageBox>
#include "definitions.h"
#include "thememanager.h"

namespace Ui {
    class RemoteStartupDlg;
}

class RemoteStartupDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(RemoteStartupDlg)
public:
    //! Constructor.
    explicit RemoteStartupDlg(QString aRemoteName, QWidget *parent = 0, QStringList *remotes = 0);
    //! Destructor.
    virtual ~RemoteStartupDlg();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::RemoteStartupDlg *m_ui;
  //  QString remote;
    QString homePath;
    //! Remotes name.
    QString remoteName;
    //! Contains possible button lirc actions.
    QStringList buttonNames;
    //! Reads possible button lirc actions from lirc file.
    void process_line(QString line);
    //! Method for calling process_line in a loop.
    void loadRemote();
    //! Inserts actions to listwidget.
    void makeButtons();
    //! Booleans to help processing lirc file.
    bool flag;
    bool raw_flag;
    //! Number or added buttons.
    int addedButtonsCount;
    //! Number of possible buttons.
    int buttonsCount;
    //! Contains remote names
    QStringList *remoteNames;
    //! Name for theme to be used creating buttons.
    QString themeUsed;
    //! If custom theme selected open theme manager.
    bool customTheme;
    //! Check theme buttons and button text for matches to make buttons with proper image.
    void setButtonPath(const QString &buttonText);
    //! Button paths.
    QString fileNameUnpressed;
    QString fileNamePressed;
    QString confFileName;
    //! When using other than default theme.
    ThemeManager *themeDlg;

 private slots:
    //! Emits signal to LayoutWidget to clear screen and make buttons.
    void on_selectThemeButton_clicked();
    void on_pushButton_clicked();
    //! Adds button to selected list.
    void itemClicked(QListWidgetItem* item);
    //! Removes button from selected list.
    void removeFromSelectedList(QListWidgetItem* item);
    void setThemeName(const QString &themeName);
    
 signals:
    //! Signal for LayoutWidget to make button.
    void addButtonToLayoutSignalFromRSD(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonTextToEmit, QStringList aCommand, int number);
    //! Signal for DownloadRemoteDlg to emit remote name to LayoutWidget.
    void remoteCreated(const QString &remoteName);
    //! Signal for LayoutWidget to clear screen.
    void lwClear();
};
#endif // REMOTESTARTUPDLG_H
