#ifndef DOWNLOADUSERREMOTEDLG_H
#define DOWNLOADUSERREMOTEDLG_H

#include <QtGui/QDialog>
#include <QListWidgetItem>
#include <QList>
#include <QMessageBox>
#include "qxtxmlrpcclient.h"
#include "definitions.h"

namespace Ui {
    class DownloadUserRemoteDlg;
}

class DownloadUserRemoteDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(DownloadUserRemoteDlg)
public:
    //! Constructor.
    explicit DownloadUserRemoteDlg(QWidget *parent = 0);
    //! Destructor
    virtual ~DownloadUserRemoteDlg();

private:
    Ui::DownloadUserRemoteDlg *m_ui;
    //! Client for PHP calls.
    QxtXmlRpcClient *client;
    //! Method for getting remotes upload version by id.
    void getRemoteVersionById(const QString &id);
    //! Holds remote versions in string format
    QStringList versions;
    //! Holds index for remote whichs version is next fetched.
    int versionIndex;
    //! Current remote id to fetch version.
    int remoteId;
    //! Holds remote ids.
    QStringList remoteIdList;
    //! Map for remote ids and versions
    QMap<QString, int> remoteVersions;
    //! Variables used with client calls.
    int listId;
    int remoteIdcall;
    int dataId;
    int remoteIds;
    int remoteVersion;
    //! Used for navigation in listwidget.
    int listState;
    //! Remote infos.
    QString category;
    QString manufacturer;
    QString model;
    QString creator;
    //! Id for particular remote.
    int remId;
    //! Remote file data.
    QString fileHash;
    QString fileName;
    //! Not used atm.
    QList<QVariant> remoteValues;
    //! If user wants to replace remote.
    bool replaceRemote;
    //! List used with client calls.
    QList<QVariant> params;
private slots:
    //! Slot for downloading remote data.
    void on_downloadPushButton_clicked();
    //! Navigates previous on listwidget.
    void on_previousPushButton_clicked();
    //! Slot client gets finish signal.
    void processReturnValue(int Id,QVariant data);
    //! Client returns error.
    void error(int i,QString string);
    //! Client returns fault.
    void fault(int i,int j,QString string);
    //! Slot for updating listwidget data.
    void updateListWidget(QListWidgetItem* item);
    //! Slot for replacing existing remote.
    void replaceRemoteSlot();

signals:
    //! Signal to tell to QtIrreco that remote has been downloaded.
    void remoteDownloaded(QString fName);
};
#endif // DOWNLOADUSERREMOTEDLG_H
