#include "commandchaindlg.h"
#include "ui_commandchaindlg.h"

CommandChainDlg::CommandChainDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::CommandChainDlg)
{
    m_ui->setupUi(this);

    flag = false;
    raw_flag = false;
    QDir dir(devicesPath);
    models = dir.entryList(QDir::NoDotAndDotDot | QDir::Files, QDir::Name);
    m_ui->remoteListWidget->addItems(models);
    m_ui->remoteListWidget->sortItems(Qt::AscendingOrder);
    m_ui->deleteRemoteButton->setDisabled(true);

    connect(m_ui->remoteListWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(getCommands(QListWidgetItem*)));
    connect(m_ui->commandlistWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(commandItemClicked(QListWidgetItem*)));
    connect(m_ui->deleteRemoteButton,SIGNAL(clicked()),this,SLOT(deleteRemote()));
}

CommandChainDlg::~CommandChainDlg()
{
    delete m_ui;
}

void CommandChainDlg::getCommands(QListWidgetItem* item)
{
    commands.clear();
    m_ui->deleteRemoteButton->setEnabled(true);
    QFile file(devicesPath + item->text());
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::warning(this,"Error with remote config","Couldn't load remote config file!",
                             QMessageBox::NoButton,QMessageBox::NoButton);
        return;
    }

    QTextStream in(&file);
    while (!in.atEnd()) {
        QString line = in.readLine();
        if(line.contains("end remote",Qt::CaseInsensitive)) {
            m_ui->commandlistWidget->clear();
            m_ui->commandlistWidget->insertItems(0,commands);
            m_ui->commandlistWidget->sortItems(Qt::AscendingOrder);
            break;
        }
        else process_line(line);
    }
    file.close();
}

void CommandChainDlg::commandItemClicked(QListWidgetItem* item)
{
    emit signalAddCommand(item->text(),m_ui->remoteListWidget->currentItem()->text());
    this->close();
}
void CommandChainDlg::process_line(QString line)
{
    if(line.contains("end codes", Qt::CaseInsensitive))
           flag = false;
    if(line.contains("end raw_codes", Qt::CaseInsensitive))
           raw_flag = false;
    if(flag) {
        if(line.contains("0x",Qt::CaseInsensitive)) {
            QString commandName = line;
            int lineLength;
            QString finalCommandName;

            commandName = commandName.trimmed();
            lineLength = commandName.length();

            for (int i=0;i<lineLength;i++) {
                 if(commandName.at(i).isSpace() == false)
                     finalCommandName.append(commandName.at(i));
                 if(commandName.at(i).isSpace() == true)
                     break;
             }

            commands.append(finalCommandName);
        }
    }
    if(raw_flag) {
         if(line.contains("name", Qt::CaseInsensitive)) {
            line = line.trimmed();
            line.remove(0,5);
            commands.append(line);
         }
    }
    if(line.contains("begin codes", Qt::CaseInsensitive))
        flag = true;
    if(line.contains("begin raw_codes", Qt::CaseInsensitive))
        raw_flag = true;
}
void CommandChainDlg::deleteRemote()
{
    remoteName = m_ui->remoteListWidget->currentItem()->text();
    confFileInUse = false;
    QDir lircDir(remotesPath);

    lircConfs = lircDir.entryList(QDir::Files);

    for(int i = 0 ; i < lircConfs.count() ; i++) {
        if(confFileInUse) break;

        if(lircConfs.at(i) != "remotes.conf")
        {
            QString remoteFile;
            remoteFile = remotesPath + lircConfs.at(i);
            QFile file(remoteFile);
            if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
                    QMessageBox::warning(this,"Error with remote config","Couldn't load remote config file!",
                                         QMessageBox::NoButton,QMessageBox::NoButton);
                    return;
                }

                QTextStream in(&file);
                while (!in.atEnd()) {
                    QString line = in.readLine();
                    read_line(line,i);
                    if(confFileInUse) break;
                }
                file.close();
        }
    }

    if(!confFileInUse)
    {
        m_ui->commandlistWidget->clear();
        delete m_ui->remoteListWidget->currentItem();

        QFile remoteFile;
        remoteFile.remove(devicesPath + remoteName);

        QFile LircConfFile("/etc/lircd.conf");
        QStringList deviceList;
        LircConfFile.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream io(&LircConfFile);
        while (!io.atEnd()) {
            QString line = io.readLine();
            deviceList.append(line);
        }
        for(int i = 0; i<deviceList.count();i++) {
            if(deviceList.at(i) =="include \"" + devicesPath + remoteName +"\"")
            deviceList.removeAt(i);
        }
        LircConfFile.close();
        LircConfFile.open(QIODevice::WriteOnly | QIODevice::Text);
        io.reset();
        for(int i= 0; i< deviceList.count();i++) {
            io << deviceList.at(i)+"\n";
        }
        if(m_ui->remoteListWidget->count() < 1)
            m_ui->deleteRemoteButton->setDisabled(true);
        LircConfFile.close();

        QFile LircPathFile(lircpathsConf);
        QStringList pathList;
        LircPathFile.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream inout(&LircPathFile);
        while (!inout.atEnd()) {
            QString line = inout.readLine();
            pathList.append(line);
        }
        for(int i = 0; i<pathList.count();i++) {
            if(pathList.at(i).contains(remoteName))
            pathList.removeAt(i);
        }
        LircPathFile.close();
        LircPathFile.open(QIODevice::WriteOnly | QIODevice::Text);
        inout.reset();
        for(int i= 0; i< pathList.count();i++) {
            inout << pathList.at(i)+"\n";
        }
        LircPathFile.close();
    }
    else
    {
         QMessageBox::warning(this,"Can't remove Lirc config file","Config file is used by " + remoteUsingLircConf,
                                         QMessageBox::NoButton,QMessageBox::NoButton);
    }
}

void CommandChainDlg::on_downloadRemoteButton_clicked()
{
    dloadRmDlg = new DownloadRemoteDlg(this, false);
    dloadRmDlg->exec();
    QDir dir(devicesPath);
    models = dir.entryList(QDir::NoDotAndDotDot | QDir::Files, QDir::Name);
    m_ui->remoteListWidget->clear();
    m_ui->commandlistWidget->clear();
    m_ui->remoteListWidget->addItems(models);
    m_ui->remoteListWidget->sortItems(Qt::AscendingOrder);
    m_ui->deleteRemoteButton->setDisabled(true);
}

void CommandChainDlg::read_line(QString line, int readIndex)
{
    if(line.contains("LircConfs:", Qt::CaseInsensitive))
        {
            line.remove(0,11);
            line.append(" ");
            QStringList list;
            QString temp("");
            for(int i=0;i<line.count();i++) {

            if(!line.at(i).isSpace())
                temp.append(line.at(i));

            else {
                list.append(temp);
                temp.clear();
            }
        }
        for(int i=0;i<list.count();i++) {

                if(list.at(i) == remoteName) {
                    confFileInUse = true;
                    remoteUsingLircConf = lircConfs.at(readIndex);
                    remoteUsingLircConf.chop(5);
                }
                if(confFileInUse) break;
            }
        }
}
