#include "backgroundcolordlg.h"
#include "ui_backgroundcolordlg.h"

BackgroundColorDlg::BackgroundColorDlg(QWidget *parent, QColor color) :
    QDialog(parent),
    m_ui(new Ui::BackgroundColorDlg),
    red(""),
    green(""),
    blue("")
{
    m_ui->setupUi(this);

    this->setWindowTitle("Select Background Color");
    // Set slider values to proper color values.
    int r = color.red();
    int g = color.green();
    int b = color.blue();

    m_ui->redScrollBar->setValue(r);
    m_ui->greenScrollBar->setValue(g);
    m_ui->blueScrollBar->setValue(b);

    this->setPreviewPalette();

    connect(m_ui->redScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
    connect(m_ui->greenScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
    connect(m_ui->blueScrollBar,SIGNAL(valueChanged(int)),this,SLOT(setPreviewPalette()));
}

BackgroundColorDlg::~BackgroundColorDlg()
{
    delete m_ui;
}



void BackgroundColorDlg::setPreviewPalette()
{
    pm = QPixmap(m_ui->previewLabel->width(), m_ui->previewLabel->height());
    pm.fill(QColor(m_ui->redScrollBar->value(), m_ui->greenScrollBar->value(), m_ui->blueScrollBar->value()));
    m_ui->previewLabel->setPixmap(pm);
}

void BackgroundColorDlg::on_selectColorButton_clicked()
{
    
    red.setNum(m_ui->redScrollBar->value(),10);
    green.setNum(m_ui->greenScrollBar->value(),10);
    blue.setNum(m_ui->blueScrollBar->value(),10);
    emit selectClicked(QColor(m_ui->redScrollBar->value(), m_ui->greenScrollBar->value(), m_ui->blueScrollBar->value()));
    emit rgbValues(red, green, blue);
    this->close();
}
