// Definition of the Socket class

#ifndef SOCKET_H
#define SOCKET_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <string>
#include <arpa/inet.h>

#include <fcntl.h>
#include <errno.h>
#include <qglobal.h>
#include <qsocketnotifier.h>
#include <QMessageBox>
#include <QWidget>


const int MAXHOSTNAME = 200;
const int MAXCONNECTIONS = 5;
const int MAXRECV = 500;


class Socket : public QObject {
    Q_OBJECT

  public:
      explicit Socket(QWidget *parent);
      virtual ~Socket();

      //! Client initialization
      bool create();
      bool connect ( const std::string host, const int port );
      int disconnectSocket();

      //! Data Transmission
      void sendSocket(const QString *action);
      int recv ( std::string& ) const;

      bool is_valid() const { return m_sock != -1; }

 private:

      int m_sock;
      sockaddr_in m_addr;

};

#endif // SOCKET_H
