#include "createbackgrounddlg.h"
#include "ui_createbackgrounddlg.h"

CreateBackgroundDlg::CreateBackgroundDlg(QWidget *parent,QVector<ThemeCreatorBackground*> *backgroundsVector) :
    QDialog(parent),
    m_ui(new Ui::CreateBackgroundDlg)
{
    m_ui->setupUi(this);
    //backgrounds = new QVector<ThemeCreatorBackground*>();
    backgrounds = backgroundsVector;
    this->setWindowTitle("Create a background");
    m_ui->addPushButton->setDisabled(true);
    connect(m_ui->lineEdit,SIGNAL(textChanged(QString)),this,SLOT(enableAddButton()));
    m_ui->lineEdit->setText("background");
    m_ui->selectPushButton->setEnabled(true);
    edit = false;
}

CreateBackgroundDlg::CreateBackgroundDlg(QWidget *parent, ThemeCreatorBackground *themeBackground,QVector<ThemeCreatorBackground*> *backgroundsVector) :
    QDialog(parent),
    m_ui(new Ui::CreateBackgroundDlg)
{
    m_ui->setupUi(this);
    //backgrounds = new QVector<ThemeCreatorBackground*>();
    backgrounds = backgroundsVector;
   // bg = new ThemeCreatorBackground();
    bg = themeBackground;
    this->setWindowTitle("Create a background");
    m_ui->addPushButton->setEnabled(true);
    connect(m_ui->lineEdit,SIGNAL(textChanged(QString)),this,SLOT(enableAddButton()));

    m_ui->lineEdit->setText(themeBackground->name);
    m_ui->label_3->setPixmap(themeBackground->background.scaled(300,180,Qt::IgnoreAspectRatio,Qt::FastTransformation));
    fileName = themeBackground->picturePath;
    background = themeBackground->background;
    m_ui->selectPushButton->setEnabled(true);
    edit = true;
}

CreateBackgroundDlg::~CreateBackgroundDlg()
{
    delete m_ui;
}
void CreateBackgroundDlg::setAddButtonText(QString text)
{
    m_ui->addPushButton->setText(text);
}

void CreateBackgroundDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CreateBackgroundDlg::on_addPushButton_clicked()
{
    if(!edit && !m_ui->lineEdit->text().isEmpty()) {
        for(int i=0;i<backgrounds->count();i++) {
            if(backgrounds->at(i)->name == m_ui->lineEdit->text()) {
                QMessageBox::warning(this,"Background name already exists!","Please choose a different background name.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
                return;
            }
        }
        emit createBackground(m_ui->lineEdit->text(),background, fileName);
        this->close();
    }
    if(edit && !m_ui->lineEdit->text().isEmpty()) {
        for(int i=0;i<backgrounds->count();i++) {
            if(backgrounds->at(i)->name == m_ui->lineEdit->text() && m_ui->lineEdit->text() != bg->name) {
                QMessageBox::warning(this,"Background name already exists!","Please choose a different background name.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);
                return;
            }
        }
        emit createBackground(m_ui->lineEdit->text(),background, fileName);
        this->close();
    }

}
void CreateBackgroundDlg::on_selectPushButton_clicked()
{
    fileName = QFileDialog::getOpenFileName(this, tr("Open Image"), themesPath, tr("Image Files (*.png)"));
    QPixmap pix(fileName);
    if(!pix.isNull()) {
        if(m_ui->lineEdit->text() != "" )
            m_ui->addPushButton->setEnabled(true);
        background = pix;
        pix = pix.scaled(300,180,Qt::IgnoreAspectRatio,Qt::FastTransformation);
        if(!pix.isNull())
        {
            m_ui->selectPushButton->setDisabled(true);
        }
        m_ui->label_3->setPixmap(pix);
    }
}
void CreateBackgroundDlg::mousePressEvent(QMouseEvent *event)
{
    if(event->pos().x() >= m_ui->label_3->pos().x() && event->pos().x() <= m_ui->label_3->pos().x() + m_ui->label_3->width()
       && event->pos().y() >= m_ui->label_3->pos().y() && event->pos().y() <= m_ui->label_3->pos().y() + m_ui->label_3->height())
            on_selectPushButton_clicked();
}
void CreateBackgroundDlg::enableAddButton()
{
    if(!background.isNull())
        m_ui->addPushButton->setEnabled(true);
    if(m_ui->lineEdit->text() == "")
        m_ui->addPushButton->setDisabled(true);
}
