#include "changeremotedlg.h"
#include "ui_changeremotedlg.h"

ChangeRemoteDlg::ChangeRemoteDlg(QMainWindow *parent, const QStringList *remoteNames) :
    QDialog(parent),
    m_ui(new Ui::ChangeRemoteDlg)
{
    m_ui->setupUi(this);
    connect(m_ui->remoteList,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(emitRemoteName(QListWidgetItem*)));
    this->setWindowTitle("Select remote");

    for(int i=0; i<remoteNames->count(); i++) {
        QString name = remoteNames->at(i);
        name.chop(5);
        m_ui->remoteList->addItem(name);
        m_ui->remoteList->item(i)->setTextAlignment(Qt::AlignHCenter);
    }
}

ChangeRemoteDlg::~ChangeRemoteDlg()
{
    delete m_ui;
}

void ChangeRemoteDlg::emitRemoteName(QListWidgetItem *item)
{
    emit setActiveRemoteText(item->text());
    this->close();
}
