#include "layoutwidget.h"
#include "buttonwidget.h"

#define LIRCD "/dev/lircd"


LayoutWidget::LayoutWidget(QMainWindow *parent ) : QWidget( parent )
{
    this->resize(800,424);
    setAcceptDrops(true);
    useModeEnabled = true;
    snapToGridEnabled = false;
    vector = new QVector<ButtonWidget*>;
    bgPath = qtirrecoImage;
    socket = new Socket(this);
    timer = new QTimer(this);
    timer2 = new QTimer(this);
    timer2Index = 0;
    timeout2 = 1;
    connect(timer,SIGNAL(timeout()),this,SLOT(sendIrCommandsSlot()));
    connect(timer2,SIGNAL(timeout()),this,SLOT(sendIrCommandsSlot2()));
    timer->setInterval(100);
    timer2->setInterval(timeout2);
}

LayoutWidget::~LayoutWidget()
{

}
void LayoutWidget::setUseModeEnabled(bool useMode)
{
    useModeEnabled = useMode;
    if(!useMode) {
        timer->stop();
        timer2->stop();
    }
}

void LayoutWidget::openEditDlg()
{
    NewButtonDlg *newButtonDlg = new NewButtonDlg(this,vector->at(currentButtonIndex), vector);
    connect(newButtonDlg,SIGNAL(addButtonToLayoutSignal(QString,QString, QString, QString,QStringList,int,int)),
            this,SLOT(editButton(QString,QString, QString, QString, QStringList,int,int)));

    newButtonDlg->setModal(true);
    newButtonDlg->show();
}

void LayoutWidget::editButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number, int timeOut)
{
     QPoint position = newButton->pos();

     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);

     int buttonWidgets;
     buttonWidgets = vector->count();
     for(int i=0;i<buttonWidgets;i++) {
        if(vector->at(i)->buttonText == newButton->buttonText) {
            vector->replace(i,pw);
        }
     }
     pw->move(position);
     pw->show();
     newButton->deleteLater();
}
void LayoutWidget::snapToGrid()
{
     if(snapToGridEnabled)
        snapToGridEnabled = false;

    else snapToGridEnabled = true;
}
void LayoutWidget::mousePressEvent(QMouseEvent *event)
{
    ButtonWidget *child = static_cast<ButtonWidget*>(childAt(event->pos()));
    if(child) {
        QPoint hotSpot = event->pos() - child->pos();
        xPos = child->x();
        yPos = child->y();
    
        QByteArray itemData;
        QDataStream dataStream(&itemData, QIODevice::WriteOnly);
        dataStream << QPoint(hotSpot) << (child->fileNameUnPressed) << (child->fileNamePressed) << (child->confFileName) << (child->buttonText) << (child->commandChain) << (child->timeOut);

        QMimeData *mimeData = new QMimeData;
        mimeData->setData("application/x-qtirreco", itemData);
        mimeData->setText(child->fileNameUnPressed);

        copyButton = child;
        QDrag *drag = new QDrag(this);
        drag->setMimeData(mimeData);

        QPainter p;
        p.begin(&copyButton->pressedPixmap);
        p.save();
        p.drawPixmap(0, 0, copyButton->pressedPixmap );
        if(copyButton->allowText && !copyButton->buttonText.contains("blank",Qt::CaseInsensitive)) {
            p.setPen(copyButton->textUpColor);
            p.setFont(copyButton->textUpFont);
            p.drawText(copyButton->rect(),Qt::AlignCenter,copyButton->buttonText);
        }
        p.restore();
        p.end();

        drag->setPixmap(copyButton->pressedPixmap);
        drag->setHotSpot(hotSpot);

        if(useModeEnabled) {

            if(copyButton->commandChain.count() == 1)
                    this->sendIrCommands(copyButton->commandChain);
             drag->exec(Qt::IgnoreAction, Qt::IgnoreAction);
        }
        else {

            child->hide();
            if (drag->exec(Qt::MoveAction | Qt::CopyAction, Qt::CopyAction) == Qt::MoveAction)
                child->close();
            else child->show();
        }
    }
 }

void LayoutWidget::dragEnterEvent(QDragEnterEvent *event)
{
    if(useModeEnabled){
        if(copyButton->commandChain.count() > 1 && copyButton->underMouse())
            this->sendIrCommands(copyButton->commandChain);
        else if(copyButton->underMouse() && !timer->isActive() && copyButton->commandChain.count() == 1) {
            timer->setInterval(100);
            timer->start();
         }
    }

    if (event->mimeData()->hasFormat("application/x-qtirreco")) {
    if (children().contains(event->source())) {
        event->setDropAction(Qt::MoveAction);
        event->accept();
        }
    else    event->acceptProposedAction();
    }
    else if (event->mimeData()->hasText())
        event->acceptProposedAction();
    else
        event->ignore();

 }

 void LayoutWidget::dragMoveEvent(QDragMoveEvent *event)
 {
    if (event->mimeData()->hasFormat("application/x-qtirreco")) {
         if (children().contains(event->source())) {
             event->setDropAction(Qt::MoveAction);
             event->accept();
         }
         else event->acceptProposedAction();
    }
    else if (event->mimeData()->hasText())
         event->acceptProposedAction();
    else event->ignore();
 }

 void LayoutWidget::dropEvent(QDropEvent *event)
 {

    if(!useModeEnabled) {
         if (event->mimeData()->hasFormat("application/x-qtirreco")) {
             QByteArray itemData = event->mimeData()->data("application/x-qtirreco");
             QDataStream dataStream(&itemData, QIODevice::ReadOnly);

             QPoint offset;
             QString fileNameUnPressed;
             QString fileNamePressed;
             QString confFileName;
             QString buttonText;
             QStringList commands;
             int timeOut;

             dataStream >> offset >> fileNameUnPressed >> fileNamePressed >> confFileName >> buttonText >> commands >> timeOut;

             newButton = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);
             newButton->move(event->pos() - offset);
             newButton->show();
             // If snap to grid enabled move button.
             if(snapToGridEnabled) {
                QPoint oldPos = newButton->pos();
                int xMultiplier = oldPos.x() / 16;
                int dividedX = oldPos.x() % 16;
                if(dividedX > 8)
                    xMultiplier +=1;

                int yMultiplier = oldPos.y() / 16;
                int dividedY = oldPos.y() % 16;
                if(dividedY > 8)
                    yMultiplier +=1;

                newButton->move(xMultiplier*16, yMultiplier*16);
             }
             newButton->setAttribute(Qt::WA_DeleteOnClose);

             int buttonWidgets;
             buttonWidgets = vector->count();
             for(int i=0;i<buttonWidgets;i++) {
                if(vector->at(i)->buttonText == newButton->buttonText) {
                    vector->replace(i,newButton);
                    currentButtonIndex = i;
                }
             }

             if (event->source() == this) {
                 event->setDropAction(Qt::MoveAction);
                 event->accept();
             }
             else event->acceptProposedAction();
         }
         else event->ignore();

         // Move button to limit area if it goes over screen area
         int buttonWidth = newButton->width();
         int buttonHeight = newButton->height();

         if(((newButton->x())+(buttonWidth)) > 800)
            newButton->move(800-buttonWidth,newButton->y());

         if(newButton->x() < 0) {
            newButton->move(0,newButton->y());
         }
         if(newButton->y()+buttonHeight > 424)
            newButton->move(newButton->x(),424 - buttonHeight);

         if(newButton->y() <= 0) {
            newButton->move(newButton->x(),0);
         }
         // End
         if((xPos-newButton->x()) < 16 && (xPos-newButton->x()) > -16 &&
                (yPos-newButton->y()) < 16 && (yPos-newButton->y()) > -16) {

             QMenu *menu = new QMenu(newButton);

             if(newButton->x() <= 300)
                 menu->setGeometry(QRect(newButton->x()+105,newButton->y()+75,50,20));

             else menu->setGeometry(QRect(newButton->x()-235,newButton->y()+75,50,20));

             menu->setFont(QFont("sans-serif",22,QFont::Bold));
             QAction *editButton = menu->addAction("Edit button");
             menu->addSeparator();
             QAction *deleteButton = menu->addAction("Delete button");

             connect(editButton,SIGNAL(triggered()),this,SLOT(openEditDlg()));
             connect(deleteButton,SIGNAL(triggered()),this,SLOT(deleteButton()));
             menu->show();
         }
     }
    else timer->stop();
}

void LayoutWidget::deleteButton()
{
    vector->at(currentButtonIndex)->deleteLater();
    vector->remove(currentButtonIndex);
}

void LayoutWidget::clearScreen()
{
    for (int i=0;i<vector->count();i++) {
        vector->at(i)->deleteLater();
    }
    vector->clear();
}

void LayoutWidget::addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, QPoint position,int timeOut)
{
     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);

     vector->append(pw);
     pw->move(position);
     pw->show();
}

void LayoutWidget::addButton(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int aNumber)
{
     int timeOut = 500;
     ButtonWidget *pw = new ButtonWidget(this, fileNameUnPressed, fileNamePressed, confFileName, buttonText, commands, timeOut);
     number = aNumber;
     int xPlace = 0;
     int yPlace = 0;
    if(number < 6) {
        xPlace = number * 128;
        yPlace = 0;
    }
    if(number > 5 && number < 12) {
        xPlace = (number - 6) * 128;
        yPlace = 128;
    }
    if(number > 11 && number < 18) {
        xPlace = (number - 12) * 128;
        yPlace = 256;
    }
    vector->append(pw);
    pw->move(xPlace, yPlace);
    pw->show();
 }

 void LayoutWidget::setBackgroundMode(int mode)
 {
    backgroundMode = mode;
 }

 void LayoutWidget::setActiveRemoteName(QString activeRemote)
 {
     activeRemoteName = activeRemote; // remote name without .conf
 }

 void LayoutWidget::setRgbInteger(int aR,int aG,int aB)
 {
     r.setNum(aR);
     g.setNum(aG);
     b.setNum(aB);
 }

 void LayoutWidget::saveRemoteToFile()
 {
     QStringList themesUsed;
     QStringList themeVersionsUsed;
     if(backgroundMode == backgroundFromTheme) {
        QString bgTheme = bgPath;
        bgTheme = bgTheme.remove(0,35);
        int slashIndex = bgTheme.indexOf(QChar('/'));
        bgTheme.remove(slashIndex,bgTheme.count()-slashIndex);
        if(!themesUsed.contains(bgTheme))
           themesUsed.append(bgTheme);
     }

    for( int i=0 ; i<vector->count() ; i++ ) {
        QString themeName;
        QString temp = vector->at(i)->fileNameUnPressed;
        if(!temp.contains("/home/user/.qtirreco")) {
            temp = temp.remove(0,35);
            int slashIndex = temp.indexOf(QChar('/'));
            temp.remove(slashIndex,temp.count()-slashIndex);
            themeName = temp;
            if(!themesUsed.contains(themeName))
                themesUsed.append(themeName);
        }
    }

    for( int i=0 ; i< themesUsed.count() ; i++ ) {
        QFile themeConf(themesPath + themesUsed.at(i) + "/theme.conf");
        themeConf.open(QIODevice::ReadOnly | QIODevice::Text);
        QTextStream in(&themeConf);
        QString version;
        while (!in.atEnd()) {
            version = in.readLine();
            if(version.contains("version=")) {
                version = version.remove(0,8);
                themeVersionsUsed.append(version);
            }
        }
        themeConf.close();
    }


    QDir dir;
    if(!dir.exists(remotesPath))
            dir.mkpath(remotesPath);

    QFile exFile(remotesPath + activeRemoteName+".conf");
    exFile.remove();
    QFile file(remotesPath + activeRemoteName +".conf");
    file.open(QIODevice::WriteOnly | QIODevice::Text);

    QTextStream out(&file);

    switch(backgroundMode) {
        case defaultBackground:
            out << "Background: default \n";
            out << "Image: default \n";
            break;
        case backgroundFromTheme:
            out << "Background: theme \n";
            out << "Image: "<< bgPath <<"\n";
            break;
        case backgroundFromImage:
            out << "Background: image \n";
            out << "Image: "<< bgPath <<"\n";
            break;
        case backgroundFromColor:
            out << "Background: color_only \n";
            out << "Color: " << r <<" "<< g <<" " << b << "\n";
            break;
        default:
            out << "Background: default \n";
            out << "Image: default \n";
            break;
    }

    int buttonCount = vector->count();
    if(buttonCount > 0) {
        for(int i=0 ; i < buttonCount ; i++) {
            out << "\nbutton: " << vector->at(i)->buttonText;
            out << "\nfileNameUnPressed: " << vector->at(i)->fileNameUnPressed;
            out << "\nfileNamePressed: " << vector->at(i)->fileNamePressed;
            out << "\nconfFileName: " << vector->at(i)->confFileName;
            out << "\nposition: " << vector->at(i)->pos().x() << ", " << vector->at(i)->pos().y();
                 if(vector->at(i)->commandChain.count() > 1)
            {
                QString time;
                time.setNum(vector->at(i)->timeOut);
                out << "\ntimeout: " + time;
            }
            out << "\ncommandChain:";
            int commandChainCount = vector->at(i)->commandChain.count();
            if(commandChainCount > 1) {
                for(int j=0 ; j < commandChainCount ; j++) {
                    out << "\ncommand: " << vector->at(i)->commandChain.at(j);
                }
            }
            if(commandChainCount == 1) {
                out << "\ncommand: " << vector->at(i)->commandChain.at(0);
            }
            out << "\nend commandChain\n";
            }
    }
    if(!themesUsed.isEmpty()) {
        out << "Themes: ";
        for(int i=0 ; i<themesUsed.count() ; i++)
            out << themesUsed.at(i) + " " ;

        out << "\nTheme versions: ";
        for(int i=0 ; i<themeVersionsUsed.count() ; i++)
            out << themeVersionsUsed.at(i) + "/" ;
    }

   themesUsed.clear();
   themeVersionsUsed.clear();
   file.close();


}


void LayoutWidget::setBackgroundImagePath(QString bgImagePath)
{
    bgPath = bgImagePath;
}

void LayoutWidget::setRgbValues(QString red,QString green,QString blue)
{
    r = red;
    g = green;
    b = blue;
}

void LayoutWidget::sendIrCommands(QStringList commands)
{

    if(commands.count() < 2) {
        socket->create();
        bool connected = socket->connect("localhost", 8765);
        if(!connected)  QMessageBox::warning(this,"Socket connection","Socket connection with lirc failed! Please try reopening software.");
        const QString command = "SEND_ONCE " +commands.at(0);
        socket->sendSocket(&command);
        bool disconnect = socket->disconnectSocket();
        if(disconnect != 0) QMessageBox::warning(this,"Socket connection","Socket disconnection with lirc failed! Please try reopening software.");

    }
    else {
        timer2->setInterval(1);
        timer2->start();
    }
}
void LayoutWidget::sendIrCommandsSlot()
{
    timer->setInterval(100);
    sendIrCommands(copyButton->commandChain);

}
void LayoutWidget::sendIrCommandsSlot2()
{

    if(timer2Index < copyButton->commandChain.count()) {
         socket->create();
         bool connected = socket->connect("localhost", 8765);
         if(!connected)  QMessageBox::warning(this,"Socket connection","Socket connection with lirc failed! Please try reopening software.");
         const QString command = "SEND_ONCE " +copyButton->commandChain.at(timer2Index);
         socket->sendSocket(&command);
         bool disconnect = socket->disconnectSocket();
         if(disconnect != 0) QMessageBox::warning(this,"Socket connection","Socket disconnection with lirc failed! Please try reopening software.");
         timer2Index++;
         timeout2 = copyButton->timeOut;
         timer2->setInterval(timeout2);
     }
    else {
        timer2->stop();
        timer2Index = 0;
    }

}
