#ifndef CREATEBACKGROUNDDLG_H
#define CREATEBACKGROUNDDLG_H

#include <QtGui/QDialog>
#include <QFileDialog>
#include <QMouseEvent>
#include "themecreatorbackground.h"
#include <QMessageBox>
#include "definitions.h"

namespace Ui {
    class CreateBackgroundDlg;
}

class CreateBackgroundDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(CreateBackgroundDlg)
public:
    //! Constructor.
    explicit CreateBackgroundDlg(QWidget *parent = 0,QVector <ThemeCreatorBackground*> *backgroundsVector = 0);
    //! Constructor used when editing background.
    explicit CreateBackgroundDlg(QWidget *parent = 0,ThemeCreatorBackground *themeBackground = 0,
                                 QVector <ThemeCreatorBackground*> *backgroundsVector = 0);
    //! Destructor.
    virtual ~CreateBackgroundDlg();
    //! Method to set addbutton text to Edit.
    void setAddButtonText(QString text);

protected:
    virtual void changeEvent(QEvent *e);
    void mousePressEvent(QMouseEvent *event);

private:
    Ui::CreateBackgroundDlg *m_ui;
    //! Background file path.
    QString fileName;
    //! Pixmap made from file path.
    QPixmap background;
    //! Vector containing theme backgrounds.
    QVector <ThemeCreatorBackground*> *backgrounds;
    //! Object copy for editing background.
    ThemeCreatorBackground *bg;
    //! Boolean to tell if editing or adding background.
    bool edit;

private slots:
    //! Slot for opening file fialog.
    void on_selectPushButton_clicked();
    //! Emits background to ThemeCreatorDlg.
    void on_addPushButton_clicked();
    //! When name and file has been selected addPushButton comes enabled.
    void enableAddButton();

signals:
    //! Contains background properties.
    void createBackground(QString name, QPixmap background, QString fileName);
};
#endif // CREATEBACKGROUNDDLG_H
