#ifndef UPLOADDBDLG_H
#define UPLOADDBDLG_H

#include <QtGui/QDialog>
#include <QMessageBox>
#include "qxtxmlrpcclient.h"
#include "definitions.h"

namespace Ui {
    class UploadDBDlg;
}

class UploadDBDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(UploadDBDlg)
public:
    //! Constructor.
    explicit UploadDBDlg(QWidget *parent, QString confFile);
    //! Destructor.
    virtual ~UploadDBDlg();

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::UploadDBDlg *m_ui;
    QxtXmlRpcClient *client;
    //! Used for client calls.
    int categoryId;
    int manufacturerId;
    int uploadId;
    QString fileName;
    QString userName;
    QString password;
    //! Boolean to tell if remote uploadable.
    bool uploadable;
    //! Final call when remote uploaded.
    int uploaded;

private slots:
    void on_UploadButton_clicked();
    void uploadRemote(QString username,QString pwd);
    void processReturnValue(int Id,QVariant data);
    void error(int i,QString string);
    void fault(int i,int j,QString string);
    void allowUploading();
};
#endif // UPLOADDBDLG_H
