#include "uploaddbdlg.h"
#include "ui_uploaddbdlg.h"
#include "logindbdlg.h"

UploadDBDlg::UploadDBDlg( QWidget *parent, QString confFile) :
    QDialog(parent),
    m_ui(new Ui::UploadDBDlg)
{
    m_ui->setupUi(this);
    fileName = confFile;

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    m_ui->UploadButton->setDisabled(true);
    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString)));
    connect(client,SIGNAL(fault(int,int,QString)),this,SLOT(fault(int,int,QString)));
    connect(m_ui->categoryCombo,SIGNAL(editTextChanged(QString)),this,SLOT(allowUploading()));
    connect(m_ui->manufacturerCombo,SIGNAL(editTextChanged(QString)),this,SLOT(allowUploading()));
    connect(m_ui->lineEdit,SIGNAL(textChanged(QString)),this,SLOT(allowUploading()));
    connect(m_ui->textEdit,SIGNAL(textChanged()),this,SLOT(allowUploading()));

    QList<QVariant> params;
    params.clear();
    categoryId = client->call("getAllCategories",params);
    manufacturerId = client->call("getAllManufacturers",params);
}

UploadDBDlg::~UploadDBDlg()
{
    delete m_ui;
}

void UploadDBDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void UploadDBDlg::on_UploadButton_clicked()
{
    LoginDbDlg *loginDlg = new LoginDbDlg(this);
    connect(loginDlg,SIGNAL(loginReady(QString,QString)),this,SLOT(uploadRemote(QString,QString)));
    loginDlg->exec();
}

void UploadDBDlg::uploadRemote(QString username,QString pwd)
{
    // Writing themes to .conf file//
    /////////////////////////////////
    userName = username;
    password = pwd;
    QFile file(remotesPath + fileName + ".conf");
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
        QMessageBox::information(this,"Remote upload","Remote config is not readable.",
                             QMessageBox::NoButton,QMessageBox::NoButton);
        return;
    }
    QTextStream in(&file);
    QString line;
    QString fileContent;
    bool uploadable = false;

    QString prevLine;
    while (!in.atEnd()) {

        line = in.readLine();
        if(line.contains("Background:"))
            uploadable = true;
        if(prevLine.contains("Background: default")) {
            line = "Image: default";
            prevLine.clear();
        }
        if(line.contains("Background: image")) {
                    QMessageBox::information(this,"Remote upload","Remote will be uploaded with default background.",
                             QMessageBox::NoButton,QMessageBox::NoButton);
                    line = "Background: default";
                    prevLine = line;
        }
        fileContent.append(line);
        fileContent.append("\n");
    }
    file.close();


    if(!uploadable) {
        QMessageBox::information(this,"Remote upload","Unable to upload remote.Config file is probably missing background.Please edit remote background and save again.",
                             QMessageBox::NoButton,QMessageBox::NoButton);
    }
    //Upload remote to database//
    /////////////////////////////
    
    if(uploadable) {
        QByteArray hasharray(QCryptographicHash::hash(fileContent.toUtf8(),QCryptographicHash::Sha1));
        hasharray = hasharray.toHex();
        QString hashdata(hasharray);

        QList<QVariant> params;
        params.append(m_ui->textEdit->toPlainText());
        params.append(m_ui->categoryCombo->currentText());
        params.append(m_ui->manufacturerCombo->currentText());
        params.append(m_ui->lineEdit->text());
        params.append(hashdata);
        params.append(QString(fileName + ".conf"));
        params.append(fileContent);
        params.append(username);
        params.append(pwd);


        uploadId = client->call("createNewRemote",params);
    }
}

void UploadDBDlg::processReturnValue(int Id,QVariant data)
{
    QStringList sList;
    if (Id == categoryId) {
        sList = data.toStringList();
        m_ui->categoryCombo->addItems(sList);
    }
    if (Id == manufacturerId) {
        sList = data.toStringList();
        m_ui->manufacturerCombo->addItems(sList);
    }
    if (Id == uploadId) {

        //data returns remote id
        QList<QVariant> params;
        params.append(data.toInt());
        params.append(true);
        params.append(userName);
        params.append(password);
        uploaded = client->call("setRemoteDownloadable",params);
    }
    if (Id == uploaded) {
        QMessageBox::information(this,"Remote upload","Remote uploaded succesfully!",
                     QMessageBox::NoButton,QMessageBox::NoButton);
        this->close();
    }
}

void UploadDBDlg::error(int i ,QString string)
{
    QMessageBox::warning(this,"Error",""+ string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}

void UploadDBDlg::fault(int i,int j,QString string)
{
    QMessageBox::warning(this,"Fault",""+ string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}

void UploadDBDlg::allowUploading()
{
    if(!m_ui->categoryCombo->currentText().isEmpty() && !m_ui->manufacturerCombo->currentText().isEmpty()
        && !m_ui->lineEdit->text().isEmpty() && !m_ui->textEdit->toPlainText().isEmpty())
        {
            m_ui->UploadButton->setEnabled(true);
        }
    else m_ui->UploadButton->setDisabled(true);
}
