#ifndef QTIRRECO_H
#define QTIRRECO_H

#include <QtGui/QMainWindow>
#include <QPainter>
#include <QPaintEvent>
#include <QFileDialog>
#include "aboutdlg.h"
#include "layoutwidget.h"
#include "backgrounddlg.h"
#include "newbuttondlg.h"
#include "downloadremotedlg.h"
#include "renameremotedlg.h"
#include "remotestartupdlg.h"
#include "thememanager.h"
#include "uploaddbdlg.h"
#include "downloaduserremotedlg.h"
#include "qxtxmlrpcclient.h"
#include "definitions.h"




class LayoutWidget;



namespace Ui
{
    class QtIrrecoClass;
}
class QtIrreco : public QMainWindow
{
    Q_OBJECT
public:
    //! Constructor.
    explicit QtIrreco(QWidget *parent = 0);
    //! Destructor.
    virtual ~QtIrreco();


private:
    Ui::QtIrrecoClass *ui;
    //! Connects menu buttons to slots.
    void connectButtons();
    //! Creates menu buttons.
    void createButtons();
    //! Hide and show methods for menu buttons in use and edit mode.
    void hideEditModeButtons();
    void showEditModeButtons();
    void hideUseModeButtons();
    void showUseModeButtons();
    //! Method for checking if any remotes have been created.
    void checkForRemotes();
    //! Few dialog objects.
    RemoteStartupDlg *rsd;
    BackgroundDlg *bg;
    //! lw used as button parent, mainwindows central widget.
    LayoutWidget *lw;
    //! Palette used for background setting.
    QPalette palette;
    //! Menu buttons.
    QPushButton *renameButton;
    QPushButton *deleteButton;
    QPushButton *saveButton;
    QPushButton *themeButton;
    QPushButton *newPushButton;
    QPushButton *showButton;
    QPushButton *backgroundButton;
    QPushButton *editButton;
    QPushButton *aboutButton;
    QPushButton *downloadButton;
    QPushButton *enableButton;
    QPushButton *newRemoteButton;
    QPushButton *upDBButton;
    QPushButton *downDBButton;
    QPushButton *dataBaseButton;
    QPushButton *snapButton;
    //! Boolean to tell if use mode enabled or disabled.
    bool useModeEnabled;
    //! Boolean to tell if menu buttons visible.
    bool buttonsVisible;
    //! Needed only when launching program to avoid remotelist to show.
    bool init;
    //! Boolean to tell if remotelist visible.
    bool remoteButtonsVisible;
    //! Method for reading current remote and all remote names on device.
    void process_line(QString line);
    //! Method to hide or show remotelist.
    void showRemoteButtons();
    //! Writes current remote to file.
    void setActiveRemote();
    //! Method to change background.
    void changeBackground(QString backgroundName,QColor backgroundColor);
    //! Method to read remotes config file.
    void readRemoteFile(QString line);
    //! When renaming,deleting or changing active remote.
    void writeRemoteChanges();
    //! When no remotes found on device.
    void noRemotes();
    //! Reads themes used in remote from file.
    void checkThemesForRemote(QString remoteFile);
    //! Reads lirc configs used in remote from file.
    void checkLircFilesForRemote(QString remoteFile);
    //! Contains remote buttons.
    QVector<QPushButton*> *buttonVector;
    //! Scrollbar used if user has more than 4 remotes.
    QScrollBar *remoteScrollBar;
    //! Remote button for "list".
    QPushButton *remoteButton;
    //! Name of active remote.
    QString activeRemote;
    //! Used when renaming remote to delete old config file.
    QString oldRemoteName;
    QString backgroundName;
    /*!
    //! NOT NEEDED remoteIndex    ?????????????????????????????????????????????????????
      !*/
    int remoteIndex;
    //! Used for managing remotelist.
    int currentRemoteButtonIndex;
    //! RGB values for background color.
    int r,g,b;
    //! Used with client to get lirc file.
    int fileId;
    int buttonsId;
    int callCounter;
    int buttonData;
    int themeIdx;
    int themeDatas;
    int downloadId;
    int themeVersionIds;
    int themeButtonIds;
    int bgData;
    int bgToFile;
    int themeBgIds;
    int unpressedToFile;
    int pressedToFile;
    int themeIdFromNameAndVersion;
    int themeDownloadCount;
    bool lastTheme;
    QString themeAuthor;
    QString themeNameFromConf;
    QString themeComments;
    QString themePreviewButton;
    QString themeVersion;
    QString themeFolder;
    QString buttonPath;
    QString  unpressedHash;
    QString  pressedHash;
    QString bgPath;
    QString  bgHash;
    void getUnpressedImage();
    void getPressedImage();
    void getThemeBackgroundsByIds();
    void getBgImage();
    void getThemeButtonsByIds();
    void downloadTheme();

    int themeBgIndex;
    int themeButtonIndex;

    QStringList *remoteNames;
    //! RGB values in string format.
    QString red,green,blue;
    //! List of lirc files.
    QStringList lircFileNames;
    //! Button datas.
    QString buttonText;
    QString fileNameUnPressed;
    QString fileNamePressed;
    QString confFileName;
    QString xPosition;
    QString yPosition;
    QStringList commandChain;
    QPoint position;
    int timeOut;

    QStringList themesForRemote;
    QStringList themeVersionsForRemote;
    QStringList lircPathsForRemote;
    QStringList lircConfs;
    QStringList dbButtonIdsList;
    QStringList dbBackgroundIdsList;
    QxtXmlRpcClient *client;

    bool showDatabaseButtons;

     //! Progress bar used when downloading or uploading theme.
    QProgressBar *progress;
    //! Value for progress bar.
    int progressValue;
    //! Enum for background mode.
    backgroundModes backgroundMode;



private slots:
    void newRemote();
    void editRemote();
    void renameRemote();
    void downloadRemote();
    void deleteRemote();
    void showRemote();
    void about();
    void theme();
    void newButton();
    void saveRemote();
    void background();
    void changeBackground();
    void showOrHideButtons();
    //! Scrolls remotelist.
    void scrollRemoteButtons(int index);
    void changeRemote();
    void changeNewRemoteName(QString newName);
    void createRemote(QString newRemoteName);
    void deleteActiveRemote();
    void addRemoteName(QString newRemoteName);
    void downloadDB();
    void uploadDB();
    void addDownloadedRemote(QString remName);
    void processReturnValue(int Id,QVariant data);
    void error(int i,QString string);
    void fault(int i,int j,QString string);
    void showDBButtons();
    void snapToGrid();


public slots:
    void AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number);
    void AddButtonToLayout(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonText, QStringList commands, int number, int timeOut);

signals:
    void remoteNameToLw(QString remoteName);
    void rgbToLw(int r,int g,int b);
    void bgImageToLw(QString bgImage);
    void remoteDeleted();
    void downloadLircFile(QString lircFile,QString filePath);
    void themeLoaded();
    //! Progressbars signal to change value.
    void progressState(int state);
};
#endif // QTIRRECO
